/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class ParameterMapSettingsLocator
implements SettingsLocator {
    private final Map<String, String[]> _parameterMap;
    private final String _parameterNamePrefix;
    private final SettingsLocator _settingsLocator;

    public ParameterMapSettingsLocator(Map<String, String[]> parameterMap, SettingsLocator settingsLocator) {
        this(parameterMap, null, settingsLocator);
    }

    public ParameterMapSettingsLocator(Map<String, String[]> parameterMap, String parameterNamePrefix, SettingsLocator settingsLocator) {
        this._parameterMap = parameterMap;
        this._parameterNamePrefix = parameterNamePrefix;
        this._settingsLocator = settingsLocator;
    }

    @Override
    public Settings getSettings() throws SettingsException {
        Settings settings = this._settingsLocator.getSettings();
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(this._parameterMap, settings);
        if (Validator.isNotNull(this._parameterNamePrefix)) {
            parameterMapSettings.setParameterNamePrefix(this._parameterNamePrefix);
        }
        return parameterMapSettings;
    }

    @Override
    public String getSettingsId() {
        return this._settingsLocator.getSettingsId();
    }
}

