/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ReflectionUtil {
    private static final Method _CLONE_METHOD;

    public static Object arrayClone(Object array) {
        Class<?> clazz = array.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Input object is not an array: " + array);
        }
        try {
            return _CLONE_METHOD.invoke(array, new Object[0]);
        }
        catch (Exception e) {
            return ReflectionUtil.throwException(e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return ReflectionUtil.unfinalField(field);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws Exception {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            ReflectionUtil.unfinalField(field);
        }
        return fields;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws Exception {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Type getGenericInterface(Object object, Class<?> interfaceClass) {
        Class<?> clazz = object.getClass();
        Type genericInterface = ReflectionUtil._getGenericInterface(clazz, interfaceClass);
        if (genericInterface != null) {
            return genericInterface;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            genericInterface = ReflectionUtil._getGenericInterface(superClass, interfaceClass);
            if (genericInterface == null) continue;
            return genericInterface;
        }
        return null;
    }

    public static Class<?> getGenericSuperType(Class<?> clazz) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType)clazz.getGenericSuperclass();
            Type[] types = parameterizedType.getActualTypeArguments();
            if (types.length > 0) {
                return (Class)types[0];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Class<?>[] getInterfaces(Object object) {
        return ReflectionUtil.getInterfaces(object, null);
    }

    public static Class<?>[] getInterfaces(Object object, ClassLoader classLoader) {
        LinkedHashSet interfaceClasses = new LinkedHashSet();
        Class<?> clazz = object.getClass();
        ReflectionUtil._getInterfaces(interfaceClasses, clazz, classLoader);
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            ReflectionUtil._getInterfaces(interfaceClasses, superClass, classLoader);
        }
        return interfaceClasses.toArray(new Class[interfaceClasses.size()]);
    }

    public static Class<?>[] getParameterTypes(Object[] arguments) {
        if (arguments == null) {
            return null;
        }
        Class[] parameterTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            parameterTypes[i] = arguments[i] == null ? null : (arguments[i] instanceof Boolean ? Boolean.TYPE : (arguments[i] instanceof Byte ? Byte.TYPE : (arguments[i] instanceof Character ? Character.TYPE : (arguments[i] instanceof Double ? Double.TYPE : (arguments[i] instanceof Float ? Float.TYPE : (arguments[i] instanceof Integer ? Integer.TYPE : (arguments[i] instanceof Long ? Long.TYPE : (arguments[i] instanceof Short ? Short.TYPE : arguments[i].getClass()))))))));
        }
        return parameterTypes;
    }

    public static Set<Method> getVisibleMethods(Class<?> clazz) {
        HashSet<Method> visibleMethods = new HashSet<Method>(Arrays.asList(clazz.getMethods()));
        visibleMethods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        while ((clazz = clazz.getSuperclass()) != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (!(!Modifier.isPrivate(modifiers) & !Modifier.isPublic(modifiers))) continue;
                visibleMethods.add(method);
            }
        }
        return visibleMethods;
    }

    public static <T> T throwException(Throwable throwable) {
        return ReflectionUtil._throwException(throwable);
    }

    public static Field unfinalField(Field field) throws Exception {
        int modifiers = field.getModifiers();
        if ((modifiers & 0x10) == 16) {
            Field modifiersField = ReflectionUtil.getDeclaredField(Field.class, "modifiers");
            modifiersField.setInt(field, modifiers & 0xFFFFFFEF);
        }
        return field;
    }

    private static Type _getGenericInterface(Class<?> clazz, Class<?> interfaceClass) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !(rawType = (parameterizedType = (ParameterizedType)genericInterface).getRawType()).equals(interfaceClass)) continue;
            return parameterizedType;
        }
        return null;
    }

    private static void _getInterfaces(Set<Class<?>> interfaceClasses, Class<?> clazz, ClassLoader classLoader) {
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            try {
                if (classLoader != null) {
                    interfaceClasses.add(classLoader.loadClass(interfaceClass.getName()));
                    continue;
                }
                interfaceClasses.add(interfaceClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static <T, E extends Throwable> T _throwException(Throwable throwable) throws E {
        throw throwable;
    }

    static {
        try {
            _CLONE_METHOD = ReflectionUtil.getDeclaredMethod(Object.class, "clone", new Class[0]);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

