/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.BNDBundleNameCheck;
import com.liferay.source.formatter.checks.BNDCapabilityCheck;
import com.liferay.source.formatter.checks.BNDDefinitionKeysCheck;
import com.liferay.source.formatter.checks.BNDDirectoryNameCheck;
import com.liferay.source.formatter.checks.BNDExportsCheck;
import com.liferay.source.formatter.checks.BNDImportsCheck;
import com.liferay.source.formatter.checks.BNDIncludeResourceCheck;
import com.liferay.source.formatter.checks.BNDLineBreaksCheck;
import com.liferay.source.formatter.checks.BNDRangeCheck;
import com.liferay.source.formatter.checks.BNDSchemaVersionCheck;
import com.liferay.source.formatter.checks.BNDStylingCheck;
import com.liferay.source.formatter.checks.BNDWebContextPathCheck;
import com.liferay.source.formatter.checks.BNDWhitespaceCheck;
import com.liferay.source.formatter.checks.FileCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};
    private final List<FileCheck> _fileChecks = new ArrayList<FileCheck>();
    private final List<FileCheck> _moduleFileChecks = new ArrayList<FileCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<FileCheck> getFileChecks() {
        return this._fileChecks;
    }

    @Override
    protected List<FileCheck> getModuleFileChecks() {
        return this._moduleFileChecks;
    }

    @Override
    protected void populateFileChecks() {
        this._fileChecks.add(new BNDWhitespaceCheck());
        this._fileChecks.add(new BNDCapabilityCheck());
        this._fileChecks.add(new BNDDefinitionKeysCheck());
        this._fileChecks.add(new BNDImportsCheck());
        this._fileChecks.add(new BNDLineBreaksCheck());
        this._fileChecks.add(new BNDRangeCheck());
        this._fileChecks.add(new BNDSchemaVersionCheck());
        this._fileChecks.add(new BNDStylingCheck());
    }

    @Override
    protected void populateModuleFileChecks() throws Exception {
        this._moduleFileChecks.add(new BNDBundleNameCheck());
        this._moduleFileChecks.add(new BNDDirectoryNameCheck());
        this._moduleFileChecks.add(new BNDExportsCheck());
        this._moduleFileChecks.add(new BNDIncludeResourceCheck());
        this._moduleFileChecks.add(new BNDWebContextPathCheck());
    }
}

