/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.json"};
    private final List<FileCheck> _fileChecks = new ArrayList<FileCheck>();
    private final Pattern _incorrectLineBreakPattern = Pattern.compile("\t[\\}\\]]{2}");
    private final Pattern _leadingSpacesPattern = Pattern.compile("(^[\t ]*)(  )([^ ])");
    private final Pattern _missingWhitespacePattern = Pattern.compile(":\\S");

    protected void checkIndentation(String line, String fileName, int expectedTabCount, int lineCount) {
        if (Validator.isNull(line)) {
            return;
        }
        int leadingTabCount = this.getLeadingTabCount(line);
        if (line.matches("\t*[\\}\\]].*")) {
            --expectedTabCount;
        }
        if (leadingTabCount == expectedTabCount) {
            return;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("Line starts with '");
        sb.append(leadingTabCount);
        sb.append("' tabs, but '");
        sb.append(expectedTabCount);
        sb.append("' tabs are expected");
        this.processMessage(fileName, sb.toString(), lineCount);
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher;
        int expectedTabCount = 0;
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineCount = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Matcher matcher2;
                this.checkIndentation(line, fileName, expectedTabCount, ++lineCount);
                while ((matcher2 = this._leadingSpacesPattern.matcher(line)).find()) {
                    line = matcher2.replaceAll("$1\t$3");
                }
                line = StringUtil.replace(line, "  ", " ");
                sb.append(line);
                sb.append("\n");
                expectedTabCount = this.getLevel(line, new String[]{"[", "{"}, new String[]{"]", "}"}, expectedTabCount);
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        if ((matcher = this._incorrectLineBreakPattern.matcher(content)).find()) {
            this.processMessage(fileName, "There should be a line break after '}'", this.getLineCount(content, matcher.start()));
        } else {
            content = this.sort(content);
        }
        matcher = this._missingWhitespacePattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            return StringUtil.insert(content, " ", matcher.start() + 1);
        }
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<FileCheck> getFileChecks() {
        return this._fileChecks;
    }

    @Override
    protected void populateFileChecks() {
        this._fileChecks.add(new WhitespaceCheck(true));
    }

    protected String sort(String content) {
        Pattern pattern1;
        Matcher matcher1;
        String tabs = "";
        while ((matcher1 = (pattern1 = Pattern.compile("(\n|^)" + tabs + "[^\n\t]*[\\{\\[]\n")).matcher(content)).find()) {
            Pattern pattern2 = Pattern.compile("((\n|^)" + tabs + "[^\n\t]*\\{\n" + tabs + "\t[^\n\t][\\s\\S]*?)\n" + tabs + "\\}");
            Matcher matcher2 = pattern2.matcher(content);
            while (matcher2.find()) {
                Pattern pattern3 = Pattern.compile("(" + tabs + "\t[^\n\t]*?([^\\{\\[]|([\\{\\[]\n[\\s\\S]*?\n" + tabs + "\t[\\}\\]]))),?(\n|$)");
                String match = matcher2.group(1);
                Matcher matcher3 = pattern3.matcher(match);
                String previousProperty = null;
                while (matcher3.find()) {
                    String property = "\n" + matcher3.group(1);
                    if (Validator.isNotNull(previousProperty) && previousProperty.compareTo(property) > 0) {
                        String replacement = StringUtil.replaceFirst(match, previousProperty, property);
                        replacement = StringUtil.replaceLast(replacement, property, previousProperty);
                        return StringUtil.replace(content, match, replacement);
                    }
                    previousProperty = property;
                }
            }
            tabs = tabs + "\t";
        }
        return content;
    }
}

