/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.TLDElementOrderCheck;
import com.liferay.source.formatter.checks.TLDTypeCheck;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TLDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.tld"};
    private final List<FileCheck> _fileChecks = new ArrayList<FileCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/WEB-INF/tld/**", "**/test_*.tld"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<FileCheck> getFileChecks() {
        return this._fileChecks;
    }

    @Override
    protected void populateFileChecks() {
        this._fileChecks.add(new WhitespaceCheck());
        this._fileChecks.add(new TLDElementOrderCheck());
        this._fileChecks.add(new TLDTypeCheck());
    }
}

