/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.XMLBuildFileCheck;
import com.liferay.source.formatter.checks.XMLCustomSQLFileCheck;
import com.liferay.source.formatter.checks.XMLDDLStructuresFileCheck;
import com.liferay.source.formatter.checks.XMLEmptyLinesCheck;
import com.liferay.source.formatter.checks.XMLFriendlyURLRoutesFileCheck;
import com.liferay.source.formatter.checks.XMLHBMFileCheck;
import com.liferay.source.formatter.checks.XMLLog4jFileCheck;
import com.liferay.source.formatter.checks.XMLLookAndFeelFileCheck;
import com.liferay.source.formatter.checks.XMLModelHintsFileCheck;
import com.liferay.source.formatter.checks.XMLPortletFileCheck;
import com.liferay.source.formatter.checks.XMLPortletPreferencesFileCheck;
import com.liferay.source.formatter.checks.XMLPoshiFileCheck;
import com.liferay.source.formatter.checks.XMLResourceActionsFileCheck;
import com.liferay.source.formatter.checks.XMLServiceFileCheck;
import com.liferay.source.formatter.checks.XMLSolrSchemaFileCheck;
import com.liferay.source.formatter.checks.XMLSpringFileCheck;
import com.liferay.source.formatter.checks.XMLStrutsConfigFileCheck;
import com.liferay.source.formatter.checks.XMLTagAttributesCheck;
import com.liferay.source.formatter.checks.XMLTestIgnorableErrorLinesFileCheck;
import com.liferay.source.formatter.checks.XMLTilesDefsFileCheck;
import com.liferay.source.formatter.checks.XMLToggleFileCheck;
import com.liferay.source.formatter.checks.XMLWebFileCheck;
import com.liferay.source.formatter.checks.XMLWhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.testcase", "**/*.toggle", "**/*.xml"};
    private static final String _NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES = "numerical.portlet.name.element.excludes";
    private static final String _SERVICE_FINDER_COLUMN_SORT_EXCLUDES = "service.finder.column.sort.excludes";
    private final List<FileCheck> _fileChecks = new ArrayList<FileCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**", "**/javadocs-*.xml", "**/logs/**", "**/portal-impl/**/*.action", "**/portal-impl/**/*.function", "**/portal-impl/**/*.macro", "**/portal-impl/**/*.testcase", "**/src/test/**", "**/test-classes/unit/**", "**/test-results/**", "**/test/unit/**", "**/tools/node**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<FileCheck> getFileChecks() {
        return this._fileChecks;
    }

    @Override
    protected void populateFileChecks() throws Exception {
        this._fileChecks.add(new XMLBuildFileCheck(this.sourceFormatterArgs.getBaseDirName()));
        this._fileChecks.add(new XMLCustomSQLFileCheck());
        this._fileChecks.add(new XMLDDLStructuresFileCheck());
        this._fileChecks.add(new XMLFriendlyURLRoutesFileCheck());
        this._fileChecks.add(new XMLHBMFileCheck());
        this._fileChecks.add(new XMLLog4jFileCheck());
        this._fileChecks.add(new XMLLookAndFeelFileCheck());
        this._fileChecks.add(new XMLModelHintsFileCheck());
        this._fileChecks.add(new XMLPortletFileCheck(this.getExcludes(_NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES), portalSource, subrepository));
        this._fileChecks.add(new XMLPortletPreferencesFileCheck());
        this._fileChecks.add(new XMLPoshiFileCheck());
        this._fileChecks.add(new XMLResourceActionsFileCheck());
        this._fileChecks.add(new XMLServiceFileCheck(this.getExcludes(_SERVICE_FINDER_COLUMN_SORT_EXCLUDES), portalSource, subrepository, this.getContent("sql/portal-tables.sql", 7), this.getPluginsInsideModulesDirectoryNames()));
        this._fileChecks.add(new XMLSolrSchemaFileCheck());
        this._fileChecks.add(new XMLSpringFileCheck());
        this._fileChecks.add(new XMLToggleFileCheck());
        if (portalSource || subrepository) {
            this._fileChecks.add(new XMLStrutsConfigFileCheck());
            this._fileChecks.add(new XMLTestIgnorableErrorLinesFileCheck());
            this._fileChecks.add(new XMLTilesDefsFileCheck());
            this._fileChecks.add(new XMLWebFileCheck(this.sourceFormatterArgs.getBaseDirName()));
        }
        this._fileChecks.add(new XMLWhitespaceCheck(this.sourceFormatterArgs.getBaseDirName()));
        this._fileChecks.add(new XMLTagAttributesCheck());
        if (portalSource || subrepository) {
            this._fileChecks.add(new XMLEmptyLinesCheck(this.sourceFormatterArgs.getBaseDirName()));
        }
    }
}

