/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

public class BNDBundleNameCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkBundleName(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkBundleName(String fileName, String absolutePath, String content) {
        String expectedBundleSymbolicName;
        String moduleName = BNDSourceUtil.getModuleName(absolutePath);
        String bundleName = BNDSourceUtil.getDefinitionValue(content, "Bundle-Name");
        if (bundleName != null) {
            String expectedBundleName;
            String strippedBundleName = StringUtil.removeChars(bundleName, '-', ' ');
            strippedBundleName = strippedBundleName.replaceAll("Implementation$", "Impl");
            if (!StringUtil.equalsIgnoreCase(strippedBundleName = strippedBundleName.replaceAll("Utilities$", "Util"), expectedBundleName = "liferay" + StringUtil.removeChars(moduleName, '-'))) {
                this.addMessage(fileName, "Incorrect Bundle-Name '" + bundleName + "'");
            }
        }
        if (moduleName.contains("-import-") || moduleName.contains("-private-")) {
            return;
        }
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName != null && !bundleSymbolicName.equals(expectedBundleSymbolicName = "com.liferay." + StringUtil.replace(moduleName, '-', '.'))) {
            this.addMessage(fileName, "Incorrect Bundle-SymbolicName '" + bundleSymbolicName + "'");
        }
    }
}

