/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDCapabilityCheck
extends BaseFileCheck {
    private final Pattern _capabilityLineBreakPattern1 = Pattern.compile(",[^\\\\]");
    private final Pattern _capabilityLineBreakPattern2 = Pattern.compile(";[^\\\\]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatCapability(content, "Provide-Capability");
        content = this._formatCapability(content, "Require-Capability");
        return content;
    }

    private String _formatCapability(String content, String definitionKey) {
        Pattern pattern = Pattern.compile("^" + definitionKey + ":[\\s\\S]*?([^\\\\]\n|\\Z)", 8);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String replacement = StringUtil.replace(match, ": ", ":\\\n\t");
        block0: while (true) {
            matcher = this._capabilityLineBreakPattern1.matcher(replacement);
            while (matcher.find()) {
                if (ToolsUtil.isInsideQuotes(replacement, matcher.start())) continue;
                replacement = StringUtil.replaceFirst(replacement, ",", ",\\\n\t", matcher.start());
                continue block0;
            }
            break;
        }
        block2: while (true) {
            matcher = this._capabilityLineBreakPattern2.matcher(replacement);
            while (matcher.find()) {
                if (ToolsUtil.isInsideQuotes(replacement, matcher.start())) continue;
                replacement = StringUtil.replaceFirst(replacement, ";", ";\\\n\t\t", matcher.start());
                continue block2;
            }
            break;
        }
        return StringUtil.replace(content, match, replacement);
    }
}

