/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPStylingCheck
extends BaseFileCheck {
    private final Pattern _emptyJavaSourceTagPattern = Pattern.compile("\n\t*<%\n+\t*%>\n");
    private final Pattern _incorrectClosingTagPattern = Pattern.compile("\n(\t*)\t((?!<\\w).)* />\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixEmptyJavaSourceTag(content);
        content = this._fixIncorrectClosingTag(content);
        content = StringUtil.replace(content, new String[]{"alert('<%= LanguageUtil.", "alert(\"<%= LanguageUtil.", "confirm('<%= LanguageUtil.", "confirm(\"<%= LanguageUtil."}, new String[]{"alert('<%= UnicodeLanguageUtil.", "alert(\"<%= UnicodeLanguageUtil.", "confirm('<%= UnicodeLanguageUtil.", "confirm(\"<%= UnicodeLanguageUtil."});
        return content;
    }

    private String _fixEmptyJavaSourceTag(String content) {
        Matcher matcher = this._emptyJavaSourceTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replace(content, matcher.group(), "");
        }
        return content;
    }

    private String _fixIncorrectClosingTag(String content) {
        Matcher matcher = this._incorrectClosingTagPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, " />\n", "\n" + matcher.group(1) + "/>\n", matcher.end(1));
        }
        return content;
    }
}

