/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDiamondOperatorCheck
extends BaseFileCheck {
    private final Pattern _diamondOperatorPattern = Pattern.compile("(return|=)\n?(\t+| )new ([A-Za-z]+)(\\s*)<([^>][^;]*?)>\\(\n*\t*.*?\\);\n", 32);
    private final List<String> _excludes;

    public JavaDiamondOperatorCheck(List<String> excludes) {
        this._excludes = excludes;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!this.isExcludedPath(this._excludes, absolutePath)) {
            content = this._applyDiamondOperator(content);
        }
        return content;
    }

    private String _applyDiamondOperator(String content) {
        Matcher matcher = this._diamondOperatorPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.contains("{\n")) continue;
            String className = matcher.group(3);
            String parameterType = matcher.group(5);
            if (!(!className.equals("AutoResetThreadLocal") && !className.equals("InitialThreadLocal") || !parameterType.startsWith("Map<") && !parameterType.startsWith("Set<"))) continue;
            String whitespace = matcher.group(4);
            String replacement = StringUtil.replaceFirst(match, whitespace + "<" + parameterType + ">", "<>");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

