/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModuleInternalImportsCheck
extends BaseFileCheck {
    private final Pattern _internalImportPattern = Pattern.compile("\nimport com\\.liferay\\.(.*\\.internal\\.([a-z].*?\\.)?[A-Z].*?)[\\.|;]");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (absolutePath.contains("/modules/core/") || absolutePath.contains("/modules/util/") || fileName.contains("/test/") || fileName.contains("/testIntegration/")) {
            return content;
        }
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (!packagePath.startsWith("com.liferay")) {
            return content;
        }
        this._checkInternalImports(fileName, absolutePath, content);
        return content;
    }

    private void _checkInternalImports(String fileName, String absolutePath, String content) {
        Matcher matcher = this._internalImportPattern.matcher(content);
        int pos = -1;
        while (matcher.find()) {
            String expectedImportFileLocation;
            File file;
            if (pos == -1) {
                pos = absolutePath.lastIndexOf("/com/liferay/");
            }
            if ((file = new File(expectedImportFileLocation = absolutePath.substring(0, pos + 13) + StringUtil.replace(matcher.group(1), '.', '/') + ".java")).exists()) continue;
            this.addMessage(fileName, "Do not import internal class from another module", this.getLineCount(content, matcher.start(1)));
        }
    }
}

