/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaModuleTestCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("Test.java")) {
            return content;
        }
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (!packagePath.startsWith("com.liferay")) {
            return content;
        }
        this._checkTestPackage(fileName, absolutePath, content, packagePath);
        return content;
    }

    private void _checkTestPackage(String fileName, String absolutePath, String content, String packagePath) {
        if (absolutePath.contains("/src/testIntegration/java/") || absolutePath.contains("/test/integration/")) {
            if (content.contains("@RunWith(Arquillian.class)") && content.contains("import org.powermock.")) {
                this.addMessage(fileName, "Do not use PowerMock inside Arquillian tests, see LPS-56706");
            }
            if (!packagePath.endsWith(".test")) {
                this.addMessage(fileName, "Module integration test must be under a test subpackage, see LPS-57722");
            }
        } else if ((absolutePath.contains("/test/unit/") || absolutePath.contains("/src/test/java/")) && packagePath.endsWith(".test")) {
            this.addMessage(fileName, "Module unit test should not be under a test subpackage, see LPS-57722");
        }
    }
}

