/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;

public class ResourceBundleCheck
extends BaseFileCheck {
    private final List<String> _excludes;

    public ResourceBundleCheck(List<String> excludes) {
        this._excludes = excludes;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("ResourceBundleCheck.java") || fileName.endsWith("ResourceBundleUtil.java") || this.isExcludedPath(this._excludes, absolutePath)) {
            return content;
        }
        int pos = content.indexOf("ResourceBundle.getBundle(");
        if (pos != -1) {
            this.addMessage(fileName, "Use ResourceBundleUtil.getBundle instead of ResourceBundle.getBundle, see LPS-58529", this.getLineCount(content, pos));
        }
        if ((pos = content.indexOf("resourceBundle.getString(")) != -1) {
            this.addMessage(fileName, "Use ResourceBundleUtil.getString instead of resourceBundle.getString, see LPS-58529", this.getLineCount(content, pos));
        }
        return content;
    }
}

