/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checks.util.XMLSourceUtil;
import com.liferay.util.xml.Dom4jUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLPortletFileCheck
extends BaseFileCheck {
    private final List<String> _excludes;
    private final boolean _portalSource;
    private final boolean _subrepository;

    public XMLPortletFileCheck(List<String> excludes, boolean portalSource, boolean subrepository) {
        this._excludes = excludes;
        this._portalSource = portalSource;
        this._subrepository = subrepository;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("/liferay-portlet.xml") || (this._portalSource || this._subrepository) && fileName.endsWith("/portlet-custom.xml") || !this._portalSource && !this._subrepository && fileName.endsWith("/portlet.xml")) {
            content = this._formatPortletXML(fileName, absolutePath, content);
        }
        return content;
    }

    private String _formatPortletXML(String fileName, String absolutePath, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        boolean checkNumericalPortletNameElement = !this.isExcludedPath(this._excludes, absolutePath);
        List portletElements = rootElement.elements("portlet");
        for (Element portletElement : portletElements) {
            Element portletNameElement;
            String portletNameText;
            if (checkNumericalPortletNameElement && !Validator.isNumber(portletNameText = (portletNameElement = portletElement.element("portlet-name")).getText())) {
                this.addMessage(fileName, "Nonstandard portlet-name element '" + portletNameText + "'");
            }
            if (fileName.endsWith("/liferay-portlet.xml")) continue;
            XMLSourceUtil.sortElementsByChildElement(portletElement, "init-param", "name");
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            if (portletPreferencesElement == null) continue;
            XMLSourceUtil.sortElementsByChildElement(portletPreferencesElement, "preference", "name");
        }
        return Dom4jUtil.toString((Node)document);
    }
}

