/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.Reader;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class SourceUtil {
    public static int getLevel(String s) {
        return SourceUtil.getLevel(s, new String[]{"("}, new String[]{")"}, 0);
    }

    public static int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return SourceUtil.getLevel(s, new String[]{increaseLevelString}, new String[]{decreaseLevelString}, 0);
    }

    public static int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return SourceUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings, 0);
    }

    public static int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        int level = startLevel;
        for (String increaseLevelString : increaseLevelStrings) {
            level = SourceUtil._adjustLevel(level, s, increaseLevelString, 1);
        }
        for (String decreaseLevelString : decreaseLevelStrings) {
            level = SourceUtil._adjustLevel(level, s, decreaseLevelString, -1);
        }
        return level;
    }

    public static Document readXML(String content) throws Exception {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read((Reader)new UnsyncStringReader(content));
    }

    private static int _adjustLevel(int level, String text, String s, int diff) {
        String[] lines;
        for (String line : lines = StringUtil.splitLines(text)) {
            if ((line = StringUtil.trim(line)).startsWith("//")) continue;
            int x = -1;
            while ((x = line.indexOf(s, x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                level += diff;
            }
        }
        return level;
    }
}

