/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class SizeIsZeroCheck
extends AbstractCheck {
    public static final String MSG_USE_METHOD = "method.use";

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void visitToken(DetailAST detailAST) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, "size");
        for (DetailAST methodCallAST : methodCallASTList) {
            this._checkMethodCall(detailAST, methodCallAST);
        }
    }

    private void _checkMethodCall(DetailAST detailAST, DetailAST methodCallAST) {
        DetailAST nextSibling = methodCallAST.getNextSibling();
        if (nextSibling == null || nextSibling.getType() != 137) {
            return;
        }
        int compareCount = GetterUtil.getInteger(nextSibling.getText());
        DetailAST parentAST = methodCallAST.getParent();
        if ((compareCount != 0 || parentAST.getType() != 116 && parentAST.getType() != 115 && parentAST.getType() != 118) && (compareCount != 1 || parentAST.getType() != 120 && parentAST.getType() != 117)) {
            return;
        }
        DetailAST dotAST = methodCallAST.getFirstChild();
        DetailAST nameAST = dotAST.findFirstToken(58);
        String variableName = nameAST.getText();
        List<DetailAST> definitionASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 21, 10);
        for (DetailAST definitionAST : definitionASTList) {
            DetailAST typeAST;
            DetailAST typeNameAST;
            String typeName;
            DetailAST definitionNameAST = definitionAST.findFirstToken(58);
            if (!variableName.equals(definitionNameAST.getText()) || !(typeName = (typeNameAST = (typeAST = definitionAST.findFirstToken(13)).findFirstToken(58)).getText()).matches(".*(Collection|List|Map|Set)")) continue;
            this.log(methodCallAST.getLineNo(), MSG_USE_METHOD, new Object[]{variableName + ".isEmpty()"});
        }
    }
}

