/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.memory;

import com.liferay.portal.kernel.concurrent.ConcurrentIdentityHashMap;
import com.liferay.portal.kernel.memory.EqualityPhantomReference;
import com.liferay.portal.kernel.memory.EqualitySoftReference;
import com.liferay.portal.kernel.memory.EqualityWeakReference;
import com.liferay.portal.kernel.memory.FinalizeAction;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Map;

public class FinalizeManager {
    public static final ReferenceFactory PHANTOM_REFERENCE_FACTORY = new ReferenceFactory(){

        @Override
        public <T> Reference<T> createReference(T reference, ReferenceQueue<? super T> referenceQueue) {
            return new EqualityPhantomReference<T>(reference, referenceQueue){

                @Override
                public void clear() {
                    _finalizeActions.remove(this);
                    super.clear();
                }
            };
        }
    };
    public static final ReferenceFactory SOFT_REFERENCE_FACTORY = new ReferenceFactory(){

        @Override
        public <T> Reference<T> createReference(T reference, ReferenceQueue<? super T> referenceQueue) {
            return new EqualitySoftReference<T>(reference, referenceQueue){

                @Override
                public void clear() {
                    _finalizeActions.remove(this);
                    super.clear();
                }
            };
        }
    };
    public static final boolean THREAD_ENABLED = Boolean.getBoolean(FinalizeManager.class.getName() + ".thread.enabled");
    public static final ReferenceFactory WEAK_REFERENCE_FACTORY = new ReferenceFactory(){

        @Override
        public <T> Reference<T> createReference(T reference, ReferenceQueue<? super T> referenceQueue) {
            return new EqualityWeakReference<T>(reference, referenceQueue){

                @Override
                public void clear() {
                    _finalizeActions.remove(this);
                    super.clear();
                }
            };
        }
    };
    private static final Map<Reference<?>, FinalizeAction> _finalizeActions = new ConcurrentIdentityHashMap();
    private static final ReferenceQueue<Object> _referenceQueue = new ReferenceQueue();

    public static <T> Reference<T> register(T reference, FinalizeAction finalizeAction, ReferenceFactory referenceFactory) {
        Reference<Object> newReference = referenceFactory.createReference(reference, _referenceQueue);
        _finalizeActions.put(newReference, finalizeAction);
        if (!THREAD_ENABLED) {
            FinalizeManager._pollingCleanup();
        }
        return newReference;
    }

    private static void _finalizeReference(Reference<? extends Object> reference) {
        FinalizeAction finalizeAction = _finalizeActions.remove(reference);
        if (finalizeAction != null) {
            try {
                finalizeAction.doFinalize(reference);
            }
            finally {
                reference.clear();
            }
        }
    }

    private static void _pollingCleanup() {
        Reference<Object> reference = null;
        while ((reference = _referenceQueue.poll()) != null) {
            FinalizeManager._finalizeReference(reference);
        }
    }

    static {
        if (THREAD_ENABLED) {
            FinalizeThread thread = new FinalizeThread("Finalize Thread");
            thread.setContextClassLoader(FinalizeManager.class.getClassLoader());
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static class FinalizeThread
    extends Thread {
        public FinalizeThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        FinalizeManager._finalizeReference(_referenceQueue.remove());
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static interface ReferenceFactory {
        public <T> Reference<T> createReference(T var1, ReferenceQueue<? super T> var2);
    }
}

