/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.generic;

import com.liferay.portal.kernel.search.BaseQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiMatchQuery
extends BaseQueryImpl {
    private String _analyzer;
    private Float _cutOffFrequency;
    private final Set<String> _fields = new HashSet<String>();
    private final Map<String, Float> _fieldsBoosts = new HashMap<String, Float>();
    private String _fuzziness;
    private MatchQuery.RewriteMethod _fuzzyRewriteMethod;
    private Boolean _lenient;
    private Integer _maxExpansions;
    private String _minShouldMatch;
    private MatchQuery.Operator _operator;
    private Integer _prefixLength;
    private Integer _slop;
    private Float _tieBreaker;
    private Type _type;
    private final String _value;
    private MatchQuery.ZeroTermsQuery _zeroTermsQuery;

    public MultiMatchQuery(String value) {
        this._value = value;
    }

    @Override
    public <T> T accept(QueryVisitor<T> queryVisitor) {
        return queryVisitor.visitQuery(this);
    }

    public void addField(String field) {
        this._fields.add(field);
    }

    public void addFields(Collection<String> fields) {
        this._fields.addAll(fields);
    }

    public void addFields(String ... fields) {
        this._fields.addAll(Arrays.asList(fields));
    }

    public String getAnalyzer() {
        return this._analyzer;
    }

    public Float getCutOffFrequency() {
        return this._cutOffFrequency;
    }

    public Set<String> getFields() {
        return this._fields;
    }

    public Map<String, Float> getFieldsBoosts() {
        return this._fieldsBoosts;
    }

    public String getFuzziness() {
        return this._fuzziness;
    }

    public MatchQuery.RewriteMethod getFuzzyRewriteMethod() {
        return this._fuzzyRewriteMethod;
    }

    public Integer getMaxExpansions() {
        return this._maxExpansions;
    }

    public String getMinShouldMatch() {
        return this._minShouldMatch;
    }

    public MatchQuery.Operator getOperator() {
        return this._operator;
    }

    public Integer getPrefixLength() {
        return this._prefixLength;
    }

    public Integer getSlop() {
        return this._slop;
    }

    public Float getTieBreaker() {
        return this._tieBreaker;
    }

    public Type getType() {
        return this._type;
    }

    public String getValue() {
        return this._value;
    }

    public MatchQuery.ZeroTermsQuery getZeroTermsQuery() {
        return this._zeroTermsQuery;
    }

    public boolean isFieldBoostsEmpty() {
        return this._fieldsBoosts.isEmpty();
    }

    public boolean isFieldsEmpty() {
        return this._fields.isEmpty();
    }

    public Boolean isLenient() {
        return this._lenient;
    }

    public void setAnalyzer(String analyzer) {
        this._analyzer = analyzer;
    }

    public void setCutOffFrequency(Float cutOffFrequency) {
        this._cutOffFrequency = cutOffFrequency;
    }

    public void setFuzziness(String fuzziness) {
        this._fuzziness = fuzziness;
    }

    public void setFuzzyRewriteMethod(MatchQuery.RewriteMethod fuzzyRewriteMethod) {
        this._fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(Boolean lenient) {
        this._lenient = lenient;
    }

    public void setMaxExpansions(Integer maxExpansions) {
        this._maxExpansions = maxExpansions;
    }

    public void setMinShouldMatch(String minShouldMatch) {
        this._minShouldMatch = minShouldMatch;
    }

    public void setOperator(MatchQuery.Operator operator) {
        this._operator = operator;
    }

    public void setPrefixLength(Integer prefixLength) {
        this._prefixLength = prefixLength;
    }

    public void setSlop(Integer slop) {
        this._slop = slop;
    }

    public void setTieBreaker(Float tieBreaker) {
        this._tieBreaker = tieBreaker;
    }

    public void setType(Type type) {
        this._type = type;
    }

    public void setZeroTermsQuery(MatchQuery.ZeroTermsQuery zeroTermsQuery) {
        this._zeroTermsQuery = zeroTermsQuery;
    }

    public String toString() {
        StringBundler sb = new StringBundler(29);
        sb.append("{analyzer=");
        sb.append(this._analyzer);
        sb.append(", className=");
        Class<?> clazz = this.getClass();
        sb.append(clazz.getSimpleName());
        sb.append(", cutOffFrequency=");
        sb.append(this._cutOffFrequency);
        sb.append(", fields=");
        sb.append(this._fields);
        sb.append(", fuzziness=");
        sb.append(this._fuzziness);
        sb.append(", lenient=");
        sb.append(this._lenient);
        sb.append(", maxExpansions=");
        sb.append(this._maxExpansions);
        sb.append(", minShouldMatch=");
        sb.append(this._minShouldMatch);
        sb.append(", operator=");
        sb.append((Object)this._operator);
        sb.append(", prefixLength=");
        sb.append(this._prefixLength);
        sb.append(", slop=");
        sb.append(this._slop);
        sb.append(", tieBreaker=");
        sb.append(this._tieBreaker);
        sb.append(", type=");
        sb.append((Object)this._type);
        sb.append(", value=");
        sb.append(this._value);
        sb.append("}");
        return sb.toString();
    }

    public static enum Type {
        BEST_FIELDS,
        CROSS_FIELDS,
        MOST_FIELDS,
        PHRASE,
        PHRASE_PREFIX;

    }
}

