/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.FTLImportsFormatter;
import com.liferay.source.formatter.checks.FTLEmptyLinesCheck;
import com.liferay.source.formatter.checks.FTLIfStatementCheck;
import com.liferay.source.formatter.checks.FTLWhitespaceCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.ftl"};
    private final Pattern _assignTagsBlockPattern = Pattern.compile("((\t*)<#assign[^<#/>]*=[^<#/>]*/>(\n|$)+){2,}", 8);
    private final Pattern _incorrectAssignTagPattern = Pattern.compile("(<#assign .*=.*[^/])>(\n|$)");
    private final Pattern _liferayVariablePattern = Pattern.compile("^\t*<#assign liferay_.*>\n", 8);
    private final Pattern _liferayVariablesPattern = Pattern.compile("(^\t*<#assign liferay_.*>\n)+", 8);
    private final Pattern _multiParameterTagPattern = Pattern.compile("\n(\t*)<@.+=.+=.+/>");
    private final Pattern _singleParameterTagPattern = Pattern.compile("(<@[\\w\\.]+ \\w+)( )?=([^=]+?)/>");
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();
    private final Pattern _stringRelationalOperationPattern = Pattern.compile("(\\W)([\\w.]+) ([!=]=) \"(\\w*)\"(.)");

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String match;
        content = StringUtil.replace(content, " >\n", ">\n");
        content = this.sortLiferayVariables(content);
        Matcher matcher = this._singleParameterTagPattern.matcher(content);
        while (matcher.find()) {
            String group3;
            String replacement = match = matcher.group();
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (group2 != null) {
                replacement = StringUtil.replaceFirst(replacement, group1 + " ", group1);
            }
            if ((group3 = matcher.group(3)).startsWith(" ")) {
                replacement = StringUtil.replaceLast(replacement, group3, group3.substring(1));
            }
            content = StringUtil.replace(content, match, replacement);
        }
        matcher = this._multiParameterTagPattern.matcher(content);
        while (matcher.find()) {
            match = matcher.group();
            if (match.contains("><")) continue;
            String strippedMatch = this.stripQuotes(match, '\"');
            if (StringUtil.count(strippedMatch, '=') <= 1) continue;
            String replacement = match;
            String tabs = matcher.group(1);
            int x = -1;
            while ((x = replacement.indexOf("=", x + tabs.length() + 2)) != -1) {
                if (ToolsUtil.isInsideQuotes(replacement, x)) continue;
                int y = replacement.lastIndexOf(" ", x);
                if (y == -1) break;
                replacement = replacement.substring(0, y) + "\n" + tabs + "\t" + replacement.substring(y + 1);
            }
            if (match.equals(replacement)) continue;
            replacement = StringUtil.replaceLast(replacement, "/>", "\n" + tabs + "/>");
            content = StringUtil.replace(content, match, replacement);
        }
        content = this.formatStringRelationalOperations(content);
        content = this.formatAssignTags(content);
        FTLImportsFormatter importsFormatter = new FTLImportsFormatter();
        return importsFormatter.format(content, null, null);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/journal/dependencies/template.ftl", "**/service/builder/dependencies/props.ftl"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    protected String formatAssignTags(String content) {
        Matcher matcher = this._incorrectAssignTagPattern.matcher(content);
        content = matcher.replaceAll("$1 />\n");
        matcher = this._assignTagsBlockPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String tabs = matcher.group(2);
            String replacement = StringUtil.removeSubstrings(match, "<#assign ", "<#assign\n", " />", "\n/>", "\t/>");
            replacement = StringUtil.removeChar(replacement, '\t');
            String[] lines = StringUtil.splitLines(replacement);
            StringBundler sb = new StringBundler(3 * lines.length + 5);
            sb.append(tabs);
            sb.append("<#assign");
            for (String line : lines) {
                sb.append("\n\t");
                sb.append(tabs);
                sb.append(line);
            }
            sb.append("\n");
            sb.append(tabs);
            sb.append("/>\n\n");
            content = StringUtil.replace(content, match, sb.toString());
        }
        return content;
    }

    protected String formatStringRelationalOperations(String content) {
        Matcher matcher = this._stringRelationalOperationPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String match = matcher.group();
        String firstChar = matcher.group(1);
        String lastChar = matcher.group(5);
        if (!firstChar.equals("(") || !lastChar.equals(")")) {
            match = content.substring(matcher.end(1), matcher.start(5));
        }
        String operator = matcher.group(3);
        String quotedString = matcher.group(4);
        String variableName = matcher.group(2);
        String replacement = null;
        if (Validator.isNull(quotedString)) {
            replacement = operator.equals("==") ? "validator.isNull(" + variableName + ")" : "validator.isNotNull(" + variableName + ")";
        } else {
            StringBundler sb = new StringBundler();
            if (operator.equals("!=")) {
                sb.append("!");
            }
            sb.append("stringUtil.equals(");
            sb.append(variableName);
            sb.append(", \"");
            sb.append(quotedString);
            sb.append("\")");
            replacement = sb.toString();
        }
        return StringUtil.replaceFirst(content, match, replacement, matcher.start());
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected void populateSourceChecks() {
        this._sourceChecks.add(new FTLWhitespaceCheck());
        this._sourceChecks.add(new FTLEmptyLinesCheck());
        this._sourceChecks.add(new FTLIfStatementCheck());
    }

    protected String sortLiferayVariables(String content) {
        Matcher matcher = this._liferayVariablesPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            Matcher matcher2 = this._liferayVariablePattern.matcher(match);
            String previousVariable = null;
            while (matcher2.find()) {
                String variable = matcher2.group();
                if (Validator.isNotNull(previousVariable) && previousVariable.compareTo(variable) > 0) {
                    String replacement = StringUtil.replaceFirst(match, previousVariable, variable);
                    replacement = StringUtil.replaceLast(replacement, variable, previousVariable);
                    return StringUtil.replace(content, match, replacement);
                }
                previousVariable = variable;
            }
        }
        return content;
    }
}

