/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.CopyrightCheck;
import com.liferay.source.formatter.checks.JavaAnnotationsCheck;
import com.liferay.source.formatter.checks.JavaAssertEqualsCheck;
import com.liferay.source.formatter.checks.JavaBooleanUsageCheck;
import com.liferay.source.formatter.checks.JavaCombineLinesCheck;
import com.liferay.source.formatter.checks.JavaDataAccessConnectionCheck;
import com.liferay.source.formatter.checks.JavaDeprecatedJavadocCheck;
import com.liferay.source.formatter.checks.JavaDeserializationSecurityCheck;
import com.liferay.source.formatter.checks.JavaDiamondOperatorCheck;
import com.liferay.source.formatter.checks.JavaEmptyLinesCheck;
import com.liferay.source.formatter.checks.JavaExceptionCheck;
import com.liferay.source.formatter.checks.JavaFinderCacheCheck;
import com.liferay.source.formatter.checks.JavaHibernateSQLCheck;
import com.liferay.source.formatter.checks.JavaIOExceptionCheck;
import com.liferay.source.formatter.checks.JavaIfStatementCheck;
import com.liferay.source.formatter.checks.JavaIllegalImportsCheck;
import com.liferay.source.formatter.checks.JavaLineBreakCheck;
import com.liferay.source.formatter.checks.JavaLogClassNameCheck;
import com.liferay.source.formatter.checks.JavaLogLevelCheck;
import com.liferay.source.formatter.checks.JavaLongLinesCheck;
import com.liferay.source.formatter.checks.JavaModuleExtendedObjectClassDefinitionCheck;
import com.liferay.source.formatter.checks.JavaModuleIllegalImportsCheck;
import com.liferay.source.formatter.checks.JavaModuleInternalImportsCheck;
import com.liferay.source.formatter.checks.JavaModuleServiceProxyFactoryCheck;
import com.liferay.source.formatter.checks.JavaModuleTestCheck;
import com.liferay.source.formatter.checks.JavaOSGiReferenceCheck;
import com.liferay.source.formatter.checks.JavaPackagePathCheck;
import com.liferay.source.formatter.checks.JavaProcessCallableCheck;
import com.liferay.source.formatter.checks.JavaResultSetCheck;
import com.liferay.source.formatter.checks.JavaSeeAnnotationCheck;
import com.liferay.source.formatter.checks.JavaStopWatchCheck;
import com.liferay.source.formatter.checks.JavaStylingCheck;
import com.liferay.source.formatter.checks.JavaSystemEventAnnotationCheck;
import com.liferay.source.formatter.checks.JavaSystemExceptionCheck;
import com.liferay.source.formatter.checks.JavaTermDividersCheck;
import com.liferay.source.formatter.checks.JavaTermOrderCheck;
import com.liferay.source.formatter.checks.JavaUpgradeClassCheck;
import com.liferay.source.formatter.checks.JavaVerifyUpgradeConnectionCheck;
import com.liferay.source.formatter.checks.JavaWhitespaceCheck;
import com.liferay.source.formatter.checks.JavaXMLSecurityCheck;
import com.liferay.source.formatter.checks.LanguageKeysCheck;
import com.liferay.source.formatter.checks.MethodCallsOrderCheck;
import com.liferay.source.formatter.checks.ResourceBundleCheck;
import com.liferay.source.formatter.checks.SessionKeysCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.StaticBlockCheck;
import com.liferay.source.formatter.checks.StringUtilCheck;
import com.liferay.source.formatter.checks.UnparameterizedClassCheck;
import com.liferay.source.formatter.checks.ValidatorEqualsCheck;
import com.liferay.source.formatter.checkstyle.util.CheckStyleUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static final String _CHECK_JAVA_FIELD_TYPES_EXCLUDES = "check.java.field.types.excludes";
    private static final String _DIAMOND_OPERATOR_EXCLUDES = "diamond.operator.excludes";
    private static final String _FIT_ON_SINGLE_LINE_EXCLUDES = "fit.on.single.line.excludes";
    private static final String _HIBERNATE_SQL_QUERY_EXCLUDES = "hibernate.sql.query.excludes";
    private static final String[] _INCLUDES = new String[]{"**/*.java"};
    private static final String _JAVATERM_SORT_EXCLUDES = "javaterm.sort.excludes";
    private static final String _LINE_LENGTH_EXCLUDES = "line.length.excludes";
    private static final String _PROXY_EXCLUDES = "proxy.excludes";
    private static final String _SECURE_DESERIALIZATION_EXCLUDES = "secure.deserialization.excludes";
    private static final String _SECURE_RANDOM_EXCLUDES = "secure.random.excludes";
    private static final String _SECURE_XML_EXCLUDES = "secure.xml.excludes";
    private static final String _STATIC_LOG_EXCLUDES = "static.log.excludes";
    private static final String _TEST_ANNOTATIONS_EXCLUDES = "test.annotations.excludes";
    private static final String _UPGRADE_DATA_ACCESS_CONNECTION_EXCLUDES = "upgrade.data.access.connection.excludes";
    private static final String _UPGRADE_SERVICE_UTIL_EXCLUDES = "upgrade.service.util.excludes";
    private boolean _allowUseServiceUtilInServiceImpl;
    private final Pattern _anonymousClassPattern = Pattern.compile("\n(\t+)(\\S.* )?new (.|\\(\n)*\\) \\{\n\n");
    private final Pattern _customSQLFilePattern = Pattern.compile("<sql file=\"(.*)\" \\/>");
    private int _maxLineLength;
    private final List<SourceCheck> _moduleSourceChecks = new ArrayList<SourceCheck>();
    private final Pattern _packagePattern = Pattern.compile("(\n|^)\\s*package (.*);\n");
    private String _portalCustomSQLContent;
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();
    private final Set<File> _ungeneratedFiles = new CopyOnWriteArraySet<File>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        if (this._hasGeneratedTag(content)) {
            return content;
        }
        this._ungeneratedFiles.add(file);
        String className = file.getName();
        int pos = className.lastIndexOf(46);
        className = className.substring(0, pos);
        String packagePath = "";
        Matcher matcher = this._packagePattern.matcher(content);
        if (matcher.find()) {
            packagePath = matcher.group(2);
        }
        if (packagePath.endsWith(".model") && content.contains("extends " + className + "Model")) {
            return content;
        }
        String newContent = content;
        if (newContent.contains(className + ".java.html")) {
            this.processMessage(fileName, "Java2HTML");
        }
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        newContent = importsFormatter.format(newContent, packagePath, className);
        if (!this.isExcludedPath(_STATIC_LOG_EXCLUDES, absolutePath)) {
            newContent = StringUtil.replace(newContent, "private Log _log", "private static final Log _log");
        }
        if ((portalSource || subrepository) && !this._allowUseServiceUtilInServiceImpl && !fileName.contains("/wsrp/internal/bind/") && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
            this.processMessage(fileName, "Do not use *ServiceUtil in *ServiceImpl class, create a reference via service.xml instead");
        }
        newContent = this.formatStringBundler(fileName, newContent, this._maxLineLength);
        newContent = StringUtil.replace(newContent, " static interface ", " interface ");
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, false, fileName);
        if (portalSource && fileName.contains("/portal-kernel/") && content.contains("import javax.servlet.jsp.")) {
            this.processMessage(fileName, "Never import javax.servlet.jsp.* from portal-kernel, see LPS-47682");
        }
        newContent = this.checkPrincipalException(newContent);
        this.checkPropertyUtils(fileName, newContent);
        if (!fileName.endsWith("GetterUtilTest.java")) {
            this.checkGetterUtilGet(fileName, newContent);
        }
        if ((pos = newContent.indexOf("\npublic ")) != -1) {
            String javaClassContent = newContent.substring(pos + 1);
            int javaClassLineCount = this.getLineCount(newContent, pos + 1);
            newContent = this.formatJavaTerms(className, packagePath, file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, "", _CHECK_JAVA_FIELD_TYPES_EXCLUDES, _JAVATERM_SORT_EXCLUDES, _TEST_ANNOTATIONS_EXCLUDES);
        }
        matcher = this._anonymousClassPattern.matcher(newContent);
        while (matcher.find()) {
            String javaClassContent;
            if (this.getLevel(matcher.group()) != 0) continue;
            int x = matcher.start() + 1;
            int y = matcher.end();
            while (this.getLevel(javaClassContent = newContent.substring(x, y), "{", "}") != 0) {
                ++y;
            }
            int javaClassLineCount = this.getLineCount(newContent, matcher.start() + 1);
            newContent = this.formatJavaTerms("", "", file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, matcher.group(1), _CHECK_JAVA_FIELD_TYPES_EXCLUDES, _JAVATERM_SORT_EXCLUDES, _TEST_ANNOTATIONS_EXCLUDES);
        }
        return this.formatJava(fileName, absolutePath, newContent);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        Object[] includes = this.getIncludes();
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        Collection<String> fileNames = null;
        fileNames = portalSource || subrepository ? this._getPortalJavaFiles((String[])includes) : this._getPluginJavaFiles((String[])includes);
        return new ArrayList<String>(fileNames);
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    protected String formatJava(String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            String packageName = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String importPackageName;
                int pos;
                ++lineCount;
                if (line.startsWith("package ")) {
                    packageName = line.substring(8, line.length() - 1);
                }
                if (line.startsWith("import ") && (pos = line.lastIndexOf(46)) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
                String trimmedLine = StringUtil.trimLeading(line);
                line = this.replacePrimitiveWrapperInstantiation(line);
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                line = this.formatEmptyArray(line);
                this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount, true);
                if (lineCount > 1) {
                    sb.append(previousLine);
                    sb.append("\n");
                }
                previousLine = line;
            }
            sb.append(previousLine);
        }
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        return newContent;
    }

    @Override
    protected List<SourceCheck> getModuleSourceChecks() {
        return this._moduleSourceChecks;
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    protected String[] getPluginExcludes(String pluginDirectoryName) {
        return new String[]{pluginDirectoryName + "**/model/*Clp.java", pluginDirectoryName + "**/model/impl/*BaseImpl.java", pluginDirectoryName + "**/model/impl/*Model.java", pluginDirectoryName + "**/model/impl/*ModelImpl.java", pluginDirectoryName + "**/service/**/service/*Service.java", pluginDirectoryName + "**/service/**/service/*ServiceClp.java", pluginDirectoryName + "**/service/**/service/*ServiceFactory.java", pluginDirectoryName + "**/service/**/service/*ServiceUtil.java", pluginDirectoryName + "**/service/**/service/*ServiceWrapper.java", pluginDirectoryName + "**/service/**/service/ClpSerializer.java", pluginDirectoryName + "**/service/**/service/messaging/*ClpMessageListener.java", pluginDirectoryName + "**/service/**/service/persistence/*Finder.java", pluginDirectoryName + "**/service/**/service/persistence/*Util.java", pluginDirectoryName + "**/service/base/*ServiceBaseImpl.java", pluginDirectoryName + "**/service/base/*ServiceClpInvoker.java", pluginDirectoryName + "**/service/http/*JSONSerializer.java", pluginDirectoryName + "**/service/http/*ServiceHttp.java", pluginDirectoryName + "**/service/http/*ServiceJSON.java", pluginDirectoryName + "**/service/http/*ServiceSoap.java", pluginDirectoryName + "**/tools/templates/**"};
    }

    protected String getPortalCustomSQLContent() throws Exception {
        if (this._portalCustomSQLContent != null) {
            return this._portalCustomSQLContent;
        }
        File portalCustomSQLFile = this.getFile("portal-impl/src/custom-sql/default.xml", 7);
        String portalCustomSQLContent = FileUtil.read(portalCustomSQLFile);
        Matcher matcher = this._customSQLFilePattern.matcher(portalCustomSQLContent);
        while (matcher.find()) {
            File customSQLFile = this.getFile("portal-impl/src/" + matcher.group(1), 7);
            if (customSQLFile == null) continue;
            portalCustomSQLContent = portalCustomSQLContent + FileUtil.read(customSQLFile);
        }
        this._portalCustomSQLContent = portalCustomSQLContent;
        return this._portalCustomSQLContent;
    }

    @Override
    protected void populateModuleSourceChecks() throws Exception {
        this._moduleSourceChecks.add(new JavaModuleExtendedObjectClassDefinitionCheck());
        boolean checkRegistryInTestClasses = GetterUtil.getBoolean(System.getProperty("source.formatter.check.registry.in.test.classes"));
        this._moduleSourceChecks.add(new JavaModuleIllegalImportsCheck(checkRegistryInTestClasses));
        this._moduleSourceChecks.add(new JavaModuleInternalImportsCheck());
        this._moduleSourceChecks.add(new JavaModuleServiceProxyFactoryCheck());
        this._moduleSourceChecks.add(new JavaModuleTestCheck());
        this._moduleSourceChecks.add(new JavaOSGiReferenceCheck(this._getModuleFileNamesMap()));
    }

    @Override
    protected void populateSourceChecks() throws Exception {
        this._populateFileChecks();
        this._populateJavaTermChecks();
    }

    @Override
    protected void postFormat() throws Exception {
        this._processCheckStyle();
    }

    @Override
    protected void preFormat() throws Exception {
        this._maxLineLength = this.sourceFormatterArgs.getMaxLineLength();
        this._allowUseServiceUtilInServiceImpl = GetterUtil.getBoolean(this.getProperty("allow.use.service.util.in.service.impl"));
    }

    @Override
    protected String processSourceChecks(String fileName, String absolutePath, String content) throws Exception {
        if (this._hasGeneratedTag(content)) {
            return content;
        }
        return super.processSourceChecks(fileName, absolutePath, content);
    }

    private Map<String, String> _getModuleFileNamesMap() throws Exception {
        HashMap<String, String> moduleFileNamesMap = new HashMap<String, String>();
        List<Object> fileNames = new ArrayList();
        String moduleRootDirLocation = "modules/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(this.sourceFormatterArgs.getBaseDirName() + moduleRootDirLocation);
            if (file.exists()) {
                fileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName() + moduleRootDirLocation, null, new String[0], this.getIncludes());
                break;
            }
            moduleRootDirLocation = "../" + moduleRootDirLocation;
        }
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            String className = StringUtil.replace(fileName, '/', '.');
            int pos = className.lastIndexOf(".com.liferay.");
            className = className.substring(pos + 1, fileName.length() - 5);
            moduleFileNamesMap.put(className, fileName);
        }
        return moduleFileNamesMap;
    }

    private Collection<String> _getPluginJavaFiles(String[] includes) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = this.getPluginExcludes("");
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private Collection<String> _getPortalJavaFiles(String[] includes) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/*_IW.java", "**/counter/service/**", "**/jsp/*", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/portal/service/**", "**/portal-client/**", "**/portal-web/test/**/*Test.java", "**/test/*-generated/**"};
        for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
            excludes = ArrayUtil.append(excludes, this.getPluginExcludes("**" + directoryName));
        }
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**/portal-client/**", "**/tools/ext_tmpl/**", "**/*_IW.java", "**/test/**/*PersistenceTest.java"};
        includes = new String[]{"**/com/liferay/portal/kernel/service/ServiceContext*.java", "**/model/BaseModel.java", "**/model/impl/BaseModelImpl.java", "**/portal-test/**/portal/service/**/*.java", "**/portal-test-integration/**/portal/service/**/*.java", "**/service/Base*.java", "**/service/PersistedModelLocalService*.java", "**/service/configuration/**/*.java", "**/service/http/*HttpTest.java", "**/service/http/*SoapTest.java", "**/service/http/TunnelUtil.java", "**/service/impl/*.java", "**/service/jms/*.java", "**/service/permission/*.java", "**/service/persistence/BasePersistence.java", "**/service/persistence/BatchSession*.java", "**/service/persistence/*FinderImpl.java", "**/service/persistence/*Query.java", "**/service/persistence/impl/*.java", "**/portal-impl/test/**/*.java", "**/util-bridges/**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private List<File> _getSuppressionsFiles() throws Exception {
        File suppressionsFile;
        String fileName = "checkstyle-suppressions.xml";
        ArrayList<File> suppressionsFiles = new ArrayList<File>();
        if (portalSource && (suppressionsFile = this.getFile("portal-impl/src/" + fileName, 7)) != null) {
            suppressionsFiles.add(suppressionsFile);
        }
        int maxDirLevel = 3;
        String parentDirName = this.sourceFormatterArgs.getBaseDirName();
        if (portalSource || subrepository) {
            maxDirLevel = 6;
            parentDirName = parentDirName + "../";
        }
        for (int i = 0; i < maxDirLevel; ++i) {
            File suppressionsFile2 = new File(parentDirName + fileName);
            if (suppressionsFile2.exists()) {
                suppressionsFiles.add(suppressionsFile2);
            }
            parentDirName = parentDirName + "../";
        }
        if (!portalSource && !subrepository) {
            return suppressionsFiles;
        }
        List<String> moduleSuppressionsFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, new String[0], new String[]{"**/modules/**/" + fileName});
        for (String moduleSuppressionsFileName : moduleSuppressionsFileNames) {
            moduleSuppressionsFileName = StringUtil.replace(moduleSuppressionsFileName, '\\', '/');
            suppressionsFiles.add(new File(moduleSuppressionsFileName));
        }
        return suppressionsFiles;
    }

    private boolean _hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR")) && !content.contains("hasGeneratedTag");
    }

    private void _populateFileChecks() throws Exception {
        this._sourceChecks.add(new JavaWhitespaceCheck());
        this._sourceChecks.add(new CopyrightCheck(this.getContent(this.sourceFormatterArgs.getCopyrightFileName(), 7)));
        this._sourceChecks.add(new JavaAnnotationsCheck());
        this._sourceChecks.add(new JavaAssertEqualsCheck());
        this._sourceChecks.add(new JavaBooleanUsageCheck());
        this._sourceChecks.add(new JavaCombineLinesCheck(this.getExcludes(_FIT_ON_SINGLE_LINE_EXCLUDES), this.sourceFormatterArgs.getMaxLineLength()));
        this._sourceChecks.add(new JavaDataAccessConnectionCheck());
        this._sourceChecks.add(new JavaDiamondOperatorCheck(this.getExcludes(_DIAMOND_OPERATOR_EXCLUDES)));
        this._sourceChecks.add(new JavaDeserializationSecurityCheck(this.getExcludes(_SECURE_DESERIALIZATION_EXCLUDES), this.getExcludes("run.outside.portal.excludes")));
        this._sourceChecks.add(new JavaEmptyLinesCheck());
        this._sourceChecks.add(new JavaExceptionCheck());
        this._sourceChecks.add(new JavaHibernateSQLCheck(this.getExcludes(_HIBERNATE_SQL_QUERY_EXCLUDES)));
        this._sourceChecks.add(new JavaIfStatementCheck(this.sourceFormatterArgs.getMaxLineLength()));
        this._sourceChecks.add(new JavaIllegalImportsCheck(this.getExcludes(_PROXY_EXCLUDES), this.getExcludes("run.outside.portal.excludes"), this.getExcludes(_SECURE_RANDOM_EXCLUDES)));
        this._sourceChecks.add(new JavaIOExceptionCheck());
        this._sourceChecks.add(new JavaLineBreakCheck(this.sourceFormatterArgs.getMaxLineLength()));
        this._sourceChecks.add(new JavaLogClassNameCheck());
        this._sourceChecks.add(new JavaLogLevelCheck());
        this._sourceChecks.add(new JavaLongLinesCheck(this.getExcludes(_LINE_LENGTH_EXCLUDES), this.sourceFormatterArgs.getMaxLineLength()));
        this._sourceChecks.add(new JavaPackagePathCheck());
        this._sourceChecks.add(new JavaProcessCallableCheck());
        this._sourceChecks.add(new JavaResultSetCheck());
        this._sourceChecks.add(new JavaSeeAnnotationCheck());
        this._sourceChecks.add(new JavaStopWatchCheck());
        this._sourceChecks.add(new JavaStylingCheck());
        this._sourceChecks.add(new JavaSystemExceptionCheck());
        this._sourceChecks.add(new MethodCallsOrderCheck(this.getExcludes("method.call.sort.excludes")));
        this._sourceChecks.add(new SessionKeysCheck());
        this._sourceChecks.add(new StringUtilCheck());
        this._sourceChecks.add(new UnparameterizedClassCheck());
        this._sourceChecks.add(new ValidatorEqualsCheck());
        if (portalSource || subrepository) {
            this._sourceChecks.add(new JavaFinderCacheCheck());
            this._sourceChecks.add(new JavaSystemEventAnnotationCheck());
            this._sourceChecks.add(new JavaVerifyUpgradeConnectionCheck(this.getExcludes(_UPGRADE_DATA_ACCESS_CONNECTION_EXCLUDES)));
            this._sourceChecks.add(new JavaUpgradeClassCheck(this.getExcludes(_UPGRADE_SERVICE_UTIL_EXCLUDES)));
            this._sourceChecks.add(new JavaXMLSecurityCheck(this.getExcludes("run.outside.portal.excludes"), this.getExcludes(_SECURE_XML_EXCLUDES)));
            this._sourceChecks.add(new ResourceBundleCheck(this.getExcludes("run.outside.portal.excludes")));
        }
        if (portalSource) {
            this._sourceChecks.add(new LanguageKeysCheck(this.getExcludes("language.keys.check.excludes"), this.getPortalLanguageProperties()));
        }
        if (GetterUtil.getBoolean(this.getProperty("add.missing.deprecation.release.version"))) {
            this._sourceChecks.add(new JavaDeprecatedJavadocCheck(portalSource, subrepository));
        }
    }

    private void _populateJavaTermChecks() throws Exception {
        this._sourceChecks.add(new JavaTermOrderCheck(this.getExcludes(_JAVATERM_SORT_EXCLUDES), portalSource, subrepository, this.getPortalCustomSQLContent()));
        this._sourceChecks.add(new JavaTermDividersCheck());
        this._sourceChecks.add(new StaticBlockCheck(this.getExcludes(_JAVATERM_SORT_EXCLUDES)));
    }

    private void _processCheckStyle() throws Exception {
        if (this._ungeneratedFiles.isEmpty()) {
            return;
        }
        Set<SourceFormatterMessage> sourceFormatterMessages = CheckStyleUtil.process(this._ungeneratedFiles, this._getSuppressionsFiles(), this.sourceFormatterArgs.getBaseDirName());
        for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
            this.processMessage(sourceFormatterMessage.getFileName(), sourceFormatterMessage.getMessage(), sourceFormatterMessage.getLineCount());
            this.printError(sourceFormatterMessage.getFileName(), sourceFormatterMessage.toString());
        }
    }
}

