/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.TagAttributesCheck;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPTagAttributesCheck
extends TagAttributesCheck {
    private final Pattern _jspTaglibPattern = Pattern.compile("<[-\\w]+:[-\\w]+ .");
    private final Pattern _multilineTagPattern = Pattern.compile("(\\s+)<[-\\w]+:[-\\w]+\n.*?(/?>)(\n|$)", 32);
    private final boolean _portalSource;
    private final Set<String> _primitiveTagAttributeDataTypes;
    private final boolean _subrepository;
    private final Map<String, JavaClass> _tagJavaClassesMap;

    public JSPTagAttributesCheck(boolean portalSource, boolean subrepository, Set<String> primitiveTagAttributeDataTypes, Map<String, JavaClass> tagJavaClassesMap) {
        this._portalSource = portalSource;
        this._subrepository = subrepository;
        this._primitiveTagAttributeDataTypes = primitiveTagAttributeDataTypes;
        this._tagJavaClassesMap = tagJavaClassesMap;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._formatSingleLineTagAttribues(fileName, content);
        content = this._formatMultiLinesTagAttribues(fileName, content);
        return content;
    }

    @Override
    protected String formatTagAttributeType(String line, String tagName, String attributeAndValue) throws Exception {
        if (attributeAndValue.matches(".*=\"<%= Boolean\\.(FALSE|TRUE) %>\".*")) {
            String newAttributeAndValue = StringUtil.replace(attributeAndValue, new String[]{"=\"<%= Boolean.FALSE %>\"", "=\"<%= Boolean.TRUE %>\""}, new String[]{"=\"<%= false %>\"", "=\"<%= true %>\""});
            return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
        }
        if (!this._portalSource && !this._subrepository) {
            return line;
        }
        if (!attributeAndValue.endsWith("\"") || attributeAndValue.contains("\"<%=")) {
            return line;
        }
        JavaClass tagJavaClass = this._tagJavaClassesMap.get(tagName);
        if (tagJavaClass == null) {
            return line;
        }
        int pos = attributeAndValue.indexOf("=\"");
        String attribute = attributeAndValue.substring(0, pos);
        String setAttributeMethodName = "set" + TextFormatter.format(attribute, 6);
        for (String dataType : this._primitiveTagAttributeDataTypes) {
            Type javaType = new Type(dataType);
            JavaMethod setAttributeMethod = null;
            while (true) {
                try {
                    setAttributeMethod = tagJavaClass.getMethodBySignature(setAttributeMethodName, new Type[]{javaType}, true);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            if (setAttributeMethod == null) continue;
            String value = attributeAndValue.substring(pos + 2, attributeAndValue.length() - 1);
            if (!this._isValidTagAttributeValue(value, dataType)) {
                return line;
            }
            String newAttributeAndValue = StringUtil.replace(attributeAndValue, "\"" + value + "\"", "\"<%= " + value + " %>\"");
            return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
        }
        if (!attributeAndValue.matches(".*=\"(false|true)\".*")) {
            return line;
        }
        JavaMethod setAttributeMethod = tagJavaClass.getMethodBySignature(setAttributeMethodName, new Type[]{new Type("java.lang.String")}, true);
        if (setAttributeMethod == null) {
            return line;
        }
        String newAttributeAndValue = StringUtil.replace(attributeAndValue, new String[]{"=\"false\"", "=\"true\""}, new String[]{"=\"<%= Boolean.FALSE.toString() %>\"", "=\"<%= Boolean.TRUE.toString() %>\""});
        return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
    }

    @Override
    protected String sortHTMLTagAttributes(String line, String value, String attributeAndValue) {
        if (!value.matches("([-a-z0-9]+ )+[-a-z0-9]+")) {
            return line;
        }
        List<String> htmlAttributes = ListUtil.fromArray(StringUtil.split(value, " "));
        Collections.sort(htmlAttributes);
        String newValue = StringUtil.merge(htmlAttributes, " ");
        if (value.equals(newValue)) {
            return line;
        }
        String newAttributeAndValue = StringUtil.replace(attributeAndValue, value, newValue);
        return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
    }

    private String _formatMultiLinesTagAttribues(String fileName, String content) throws Exception {
        Matcher matcher = this._multilineTagPattern.matcher(content);
        while (matcher.find()) {
            char beforeClosingTagChar = content.charAt(matcher.start(2) - 1);
            if (beforeClosingTagChar != '\n' && beforeClosingTagChar != '\t') {
                String closingTag = matcher.group(2);
                String whitespace = matcher.group(1);
                String tabs = StringUtil.removeChar(whitespace, '\n');
                return StringUtil.replaceFirst(content, closingTag, "\n" + tabs + closingTag, matcher.start(2));
            }
            String tag = matcher.group();
            String singlelineTag = StringUtil.removeChar(StringUtil.trim(tag), '\t');
            String newTag = this.formatTagAttributes(fileName, tag, singlelineTag = StringUtil.replace(singlelineTag, '\n', ' '), this.getLineCount(content, matcher.end(1)), false);
            if (tag.equals(newTag)) continue;
            return StringUtil.replace(content, tag, newTag);
        }
        return content;
    }

    private String _formatSingleLineTagAttribues(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.matches("<\\w+ .*>.*")) {
                    line = this.formatTagAttributes(fileName, line, trimmedLine, lineCount, false);
                }
                Matcher matcher = this._jspTaglibPattern.matcher(line);
                while (matcher.find()) {
                    line = this.formatTagAttributes(fileName, line, line.substring(matcher.start()), lineCount, false);
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private boolean _isValidTagAttributeValue(String value, String dataType) {
        if (dataType.equals("boolean")) {
            return Validator.isBoolean(value);
        }
        if (dataType.equals("double")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }
        if (dataType.equals("int") || dataType.equals("long")) {
            return Validator.isNumber(value);
        }
        return false;
    }
}

