/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.JSPUnusedTermCheck;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPUnusedTaglibCheck
extends JSPUnusedTermCheck {
    private final Map<String, String> _contentsMap;
    private final Pattern _taglibURIPattern = Pattern.compile("<%@\\s+taglib uri=.* prefix=\"(.*?)\" %>");

    public JSPUnusedTaglibCheck(Map<String, String> contentsMap) {
        this._contentsMap = contentsMap;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        content = this._removeUnusedTaglibs(fileName, content, checkedFileNames, includeFileNames);
        return content;
    }

    private String _removeUnusedTaglibs(String fileName, String content, Set<String> checkedFileNames, Set<String> includeFileNames) {
        Matcher matcher = this._taglibURIPattern.matcher(content);
        while (matcher.find()) {
            String regex = "<" + matcher.group(1) + ":";
            if (!this.hasUnusedJSPTerm(fileName, regex, "taglib", checkedFileNames, includeFileNames, this._contentsMap)) continue;
            return StringUtil.removeSubstring(content, matcher.group());
        }
        return content;
    }
}

