/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class JSPUnusedTermCheck
extends BaseFileCheck {
    protected boolean hasUnusedJSPTerm(String fileName, String regex, String type, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        includeFileNames.add(fileName);
        HashSet<String> checkedForUnusedJSPTerm = new HashSet<String>();
        return !this.isJSPTermRequired(fileName, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap);
    }

    protected boolean isJSPTermRequired(String fileName, String regex, String type, Set<String> checkedForUnusedJSPTerm, Set<String> checkedForIncludesFileNames, Set<String> includeFileNames, Map<String, String> contentsMap) {
        String[] includeFileNamesArray;
        if (checkedForUnusedJSPTerm.contains(fileName)) {
            return false;
        }
        checkedForUnusedJSPTerm.add(fileName);
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find() && (!type.equals("variable") || checkedForUnusedJSPTerm.size() > 1 || matcher.find())) {
            return true;
        }
        if (!checkedForIncludesFileNames.contains(fileName)) {
            includeFileNames.addAll(JSPSourceUtil.getJSPIncludeFileNames(fileName, includeFileNames, contentsMap));
            includeFileNames.addAll(JSPSourceUtil.getJSPReferenceFileNames(fileName, includeFileNames, contentsMap));
        }
        checkedForIncludesFileNames.add(fileName);
        for (String includeFileName : includeFileNamesArray = includeFileNames.toArray(new String[includeFileNames.size()])) {
            if (checkedForUnusedJSPTerm.contains(includeFileName) || !this.isJSPTermRequired(includeFileName, regex, type, checkedForUnusedJSPTerm, checkedForIncludesFileNames, includeFileNames, contentsMap)) continue;
            return true;
        }
        return false;
    }
}

