/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationsCheck
extends BaseFileCheck {
    private final Pattern _annotationLineBreakPattern1 = Pattern.compile("[{=]\n.*(\" \\+\n\t*\")");
    private final Pattern _annotationLineBreakPattern2 = Pattern.compile("=(\n\t*)\"");
    private final Pattern _annotationMetaTypePattern = Pattern.compile("[\\s\\(](name|description) = \"%");
    private final Pattern _modifierPattern = Pattern.compile("[^\n]\n(\t*)(public|protected|private)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._formatAnnotations(content);
        return content;
    }

    private String _fixAnnotationLineBreaks(String annotation, String indent) {
        Matcher matcher = this._annotationLineBreakPattern1.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), "", matcher.start());
        }
        matcher = this._annotationLineBreakPattern2.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), " ", matcher.start());
        }
        if (annotation.matches(".*\\(\n[\\S\\s]*[^\t\n]\\)\n")) {
            return StringUtil.replaceLast(annotation, ")", "\n" + indent + ")");
        }
        return annotation;
    }

    private String _fixAnnotationMetaTypeProperties(String annotation) {
        if (!annotation.contains("@Meta.")) {
            return annotation;
        }
        Matcher matcher = this._annotationMetaTypePattern.matcher(annotation);
        if (!matcher.find()) {
            return annotation;
        }
        return StringUtil.replaceFirst(annotation, "%", "", matcher.start());
    }

    private String _formatAnnotations(String content) throws Exception {
        List<String> annotationsBlocks = this._getAnnotationsBlocks(content);
        for (String annotationsBlock : annotationsBlocks) {
            String indent = this._getIndent(annotationsBlock);
            String newAnnotationsBlock = this._formatAnnotations(annotationsBlock, indent, true);
            content = StringUtil.replace(content, "\n" + annotationsBlock, "\n" + newAnnotationsBlock);
        }
        return content;
    }

    private String _formatAnnotations(String annotationsBlock, String indent, boolean sortAnnotations) throws Exception {
        List<String> annotations = this._splitAnnotations(annotationsBlock, indent);
        String previousAnnotation = null;
        for (String annotation : annotations) {
            String newAnnotation = annotation;
            if (newAnnotation.contains("(")) {
                newAnnotation = this._fixAnnotationLineBreaks(newAnnotation, indent);
                newAnnotation = this._fixAnnotationMetaTypeProperties(newAnnotation);
                newAnnotation = this._sortAnnotationParameterProperties(newAnnotation);
                newAnnotation = this._formatAnnotations(newAnnotation, indent + "\t\t", false);
                annotationsBlock = StringUtil.replace(annotationsBlock, annotation, newAnnotation);
            }
            if (!sortAnnotations) continue;
            if (Validator.isNotNull(previousAnnotation) && previousAnnotation.compareToIgnoreCase(newAnnotation) > 0) {
                annotationsBlock = StringUtil.replaceFirst(annotationsBlock, previousAnnotation, newAnnotation);
                annotationsBlock = StringUtil.replaceLast(annotationsBlock, newAnnotation, previousAnnotation);
            }
            previousAnnotation = newAnnotation;
        }
        return annotationsBlock;
    }

    private List<String> _getAnnotationsBlocks(String content) {
        ArrayList<String> annotationsBlocks = new ArrayList<String>();
        Matcher matcher = this._modifierPattern.matcher(content);
        block0: while (matcher.find()) {
            int lineCount = this.getLineCount(content, matcher.end());
            String annotationsBlock = "";
            int i = lineCount - 1;
            while (true) {
                String line;
                if (Validator.isNull(line = this.getLine(content, i)) || line.matches("\t*(private|public|protected| \\*/).*")) {
                    if (!Validator.isNotNull(annotationsBlock)) continue block0;
                    annotationsBlocks.add(annotationsBlock);
                    continue block0;
                }
                annotationsBlock = line + "\n" + annotationsBlock;
                --i;
            }
        }
        return annotationsBlocks;
    }

    private String _getIndent(String s) {
        StringBundler sb = new StringBundler();
        for (char c : s.toCharArray()) {
            if (c != '\t') break;
            sb.append(c);
        }
        return sb.toString();
    }

    private String _sortAnnotationParameterProperties(String annotation) {
        int x = annotation.indexOf("property = {");
        if (x == -1) {
            return annotation;
        }
        int y = x;
        while (ToolsUtil.isInsideQuotes(annotation, y = annotation.indexOf(125, y + 1))) {
        }
        String parameterProperties = annotation.substring(x + 12, y);
        parameterProperties = StringUtil.replace(parameterProperties, "\n", " ");
        String[] parameterPropertiesArray = StringUtil.split(parameterProperties, ", ");
        String previousPropertyName = null;
        String previousPropertyNameAndValue = null;
        for (String parameterProperty : parameterPropertiesArray) {
            x = parameterProperty.indexOf(34);
            y = parameterProperty.indexOf(61, x);
            int z = x;
            while ((z = parameterProperty.indexOf(34, z + 1)) != -1 && ToolsUtil.isInsideQuotes(parameterProperty, z)) {
            }
            if (x == -1 || y == -1 || z == -1) {
                return annotation;
            }
            String propertyName = parameterProperty.substring(x + 1, y);
            String propertyNameAndValue = parameterProperty.substring(x + 1, z);
            if (Validator.isNotNull(previousPropertyName) && previousPropertyName.compareToIgnoreCase(propertyName) > 0) {
                annotation = StringUtil.replaceFirst(annotation, previousPropertyNameAndValue, propertyNameAndValue);
                annotation = StringUtil.replaceLast(annotation, propertyNameAndValue, previousPropertyNameAndValue);
                return annotation;
            }
            previousPropertyName = propertyName;
            previousPropertyNameAndValue = propertyNameAndValue;
        }
        return annotation;
    }

    private List<String> _splitAnnotations(String annotationsBlock, String indent) throws Exception {
        ArrayList<String> annotations = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(annotationsBlock));){
            String annotation = null;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (annotation == null) {
                    if (!line.startsWith(indent + "@")) continue;
                    annotation = line + "\n";
                    continue;
                }
                String lineIndent = this._getIndent(line);
                if (lineIndent.length() < indent.length()) {
                    annotations.add(annotation);
                    annotation = null;
                    continue;
                }
                if (line.startsWith(indent + "@")) {
                    annotations.add(annotation);
                    annotation = line + "\n";
                    continue;
                }
                annotation = annotation + line + "\n";
            }
            if (Validator.isNotNull(annotation)) {
                annotations.add(annotation);
            }
        }
        return annotations;
    }
}

