/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checks.util.XMLSourceUtil;
import com.liferay.util.xml.Dom4jUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class XMLDDLStructuresFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("structures.xml")) {
            content = this._formatDDLStructuresXML(content);
        }
        return content;
    }

    private String _formatDDLStructuresXML(String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        XMLSourceUtil.sortElementsByChildElement(rootElement, "structure", "name");
        List structureElements = rootElement.elements("structure");
        for (Element structureElement : structureElements) {
            Element structureRootElement = structureElement.element("root");
            this._sortElementsByAttribute(structureRootElement, "dynamic-element", "name");
            List dynamicElementElements = structureRootElement.elements("dynamic-element");
            for (Element dynamicElementElement : dynamicElementElements) {
                Element metaDataElement = dynamicElementElement.element("meta-data");
                this._sortElementsByAttribute(metaDataElement, "entry", "name");
            }
        }
        return Dom4jUtil.toString((Node)document);
    }

    /*
     * WARNING - void declaration
     */
    private void _sortElementsByAttribute(Element element, String elementName, String attributeName) {
        void var7_14;
        Element curElement;
        Element element2;
        TreeMap<String, Element> elementsMap = new TreeMap<String, Element>();
        List elements = element.elements();
        for (Element element3 : elements) {
            element3.detach();
            if (!elementName.equals(element3.getName())) continue;
            String attributeValue = element3.attributeValue(attributeName);
            elementsMap.put(attributeValue, element3);
        }
        Iterator<Object> iterator = elements.iterator();
        while (iterator.hasNext() && !elementName.equals((element2 = (Element)iterator.next()).getName())) {
            element.add(element2);
        }
        for (Map.Entry entry : elementsMap.entrySet()) {
            curElement = (Element)entry.getValue();
            element.add(curElement);
        }
        boolean foundLastElementWithElementName = false;
        boolean bl = false;
        while (var7_14 < elements.size()) {
            curElement = (Element)elements.get((int)var7_14);
            if (!foundLastElementWithElementName) {
                Element nextElement;
                if (elementName.equals(curElement.getName()) && var7_14 + true < elements.size() && !elementName.equals((nextElement = (Element)elements.get((int)(var7_14 + true))).getName())) {
                    foundLastElementWithElementName = true;
                }
            } else {
                element.add(curElement);
            }
            ++var7_14;
        }
    }
}

