/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPSourceUtil {
    private static final Pattern _javaEndTagPattern = Pattern.compile("[\n\t]%>(\n|\\Z)");
    private static final Pattern _javaStartTagPattern = Pattern.compile("[\n\t]<%\\!?\n");
    private static final Pattern _jspIncludeFilePattern = Pattern.compile("/.*\\.(jsp[f]?|svg)");

    public static List<String> addIncludedAndReferencedFileNames(List<String> fileNames, Set<String> checkedFileNames, Map<String, String> contentsMap) {
        HashSet<String> includedAndReferencedFileNames = new HashSet<String>();
        for (String fileName : fileNames) {
            if (!checkedFileNames.add(fileName)) continue;
            fileName = StringUtil.replace(fileName, '\\', '/');
            includedAndReferencedFileNames.addAll(JSPSourceUtil.getJSPIncludeFileNames(fileName, fileNames, contentsMap));
            includedAndReferencedFileNames.addAll(JSPSourceUtil.getJSPReferenceFileNames(fileName, fileNames, contentsMap));
        }
        if (includedAndReferencedFileNames.isEmpty()) {
            return fileNames;
        }
        for (String fileName : includedAndReferencedFileNames) {
            if (fileNames.contains(fileName = StringUtil.replace(fileName, '/', '\\'))) continue;
            fileNames.add(fileName);
        }
        return JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, checkedFileNames, contentsMap);
    }

    public static String buildFullPathIncludeFileName(String fileName, String includeFileName, Map<String, String> contentsMap) {
        String path = fileName;
        int y;
        while ((y = path.lastIndexOf(47)) != -1) {
            String fullPathIncludeFileName = path.substring(0, y) + includeFileName;
            if (contentsMap.containsKey(fullPathIncludeFileName) && !fullPathIncludeFileName.equals(fileName)) {
                return fullPathIncludeFileName;
            }
            path = path.substring(0, y);
        }
        return "";
    }

    public static Set<String> getJSPIncludeFileNames(String fileName, Collection<String> fileNames, Map<String, String> contentsMap) {
        int y;
        HashSet<String> includeFileNames = new HashSet<String>();
        String content = contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return includeFileNames;
        }
        int x = 0;
        while ((x = content.indexOf("<%@ include file=", x)) != -1 && (x = content.indexOf(34, x)) != -1 && (y = content.indexOf(34, x + 1)) != -1) {
            Matcher matcher;
            String includeFileName = content.substring(x + 1, y);
            if (!includeFileName.startsWith("/")) {
                includeFileName = "/" + includeFileName;
            }
            if (!(matcher = _jspIncludeFilePattern.matcher(includeFileName)).find()) {
                throw new RuntimeException("Invalid include " + includeFileName);
            }
            String extension = matcher.group(1);
            if (extension.equals("svg")) {
                x = y;
                continue;
            }
            if (!(!(includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, contentsMap)).endsWith("jsp") && !includeFileName.endsWith("jspf") || includeFileName.endsWith("html/common/init.jsp") || includeFileName.endsWith("html/portlet/init.jsp") || includeFileName.endsWith("html/taglib/init.jsp") || fileNames.contains(includeFileName))) {
                includeFileNames.add(includeFileName);
            }
            x = y;
        }
        return includeFileNames;
    }

    public static Set<String> getJSPReferenceFileNames(String fileName, Collection<String> fileNames, Map<String, String> contentsMap) {
        HashSet<String> referenceFileNames = new HashSet<String>();
        if (!(fileName.endsWith("init.jsp") || fileName.endsWith("init.jspf") || fileName.contains("init-ext.jsp"))) {
            return referenceFileNames;
        }
        block0: for (Map.Entry<String, String> entry : contentsMap.entrySet()) {
            String sharedPath;
            String referenceFileName = entry.getKey();
            if (fileNames.contains(referenceFileName) || Validator.isNull(sharedPath = fileName.substring(0, StringUtil.startsWithWeight(referenceFileName, fileName))) || !sharedPath.contains("/")) continue;
            if (!sharedPath.endsWith("/")) {
                sharedPath = sharedPath.substring(0, sharedPath.lastIndexOf(47) + 1);
            }
            String content = null;
            int x = -1;
            while ((x = sharedPath.indexOf(47, x + 1)) != -1) {
                if (content == null) {
                    content = entry.getValue();
                }
                if (!content.contains("<%@ include file=\"" + fileName.substring(x)) && !content.contains("<%@ include file=\"" + fileName.substring(x + 1))) continue;
                referenceFileNames.add(referenceFileName);
                continue block0;
            }
        }
        return referenceFileNames;
    }

    public static boolean isJavaSource(String content, int pos) {
        String s = content.substring(pos);
        Matcher matcher = _javaEndTagPattern.matcher(s);
        if (!matcher.find()) {
            return false;
        }
        return !(matcher = _javaStartTagPattern.matcher(s = s.substring(0, matcher.start()))).find();
    }
}

