/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class NumberSuffixCheck
extends AbstractCheck {
    public static final String MSG_INCORRECT_SUFFIX = "suffix.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{142, 140, 141};
    }

    public void visitToken(DetailAST detailAST) {
        if (detailAST.getType() == 142) {
            this._checkType(detailAST, "double", "d");
        } else if (detailAST.getType() == 140) {
            this._checkType(detailAST, "float", "f");
        } else if (detailAST.getType() == 141) {
            this._checkType(detailAST, "long", "l");
        }
    }

    private void _checkType(DetailAST detailAST, String type, String suffix) {
        String text = detailAST.getText();
        if (text.endsWith(suffix)) {
            this.log(detailAST.getLineNo(), MSG_INCORRECT_SUFFIX, new Object[]{StringUtil.toUpperCase(suffix), type});
        }
    }
}

