/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.BNDBundleNameCheck;
import com.liferay.source.formatter.checks.BNDCapabilityCheck;
import com.liferay.source.formatter.checks.BNDDefinitionKeysCheck;
import com.liferay.source.formatter.checks.BNDDirectoryNameCheck;
import com.liferay.source.formatter.checks.BNDExportsCheck;
import com.liferay.source.formatter.checks.BNDImportsCheck;
import com.liferay.source.formatter.checks.BNDIncludeResourceCheck;
import com.liferay.source.formatter.checks.BNDLineBreaksCheck;
import com.liferay.source.formatter.checks.BNDRangeCheck;
import com.liferay.source.formatter.checks.BNDSchemaVersionCheck;
import com.liferay.source.formatter.checks.BNDStylingCheck;
import com.liferay.source.formatter.checks.BNDWebContextPathCheck;
import com.liferay.source.formatter.checks.BNDWhitespaceCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BNDSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.bnd"};
    private final List<SourceCheck> _moduleSourceChecks = new ArrayList<SourceCheck>();
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<SourceCheck> getModuleSourceChecks() {
        return this._moduleSourceChecks;
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected void populateModuleSourceChecks() throws Exception {
        this._moduleSourceChecks.add(new BNDBundleNameCheck());
        this._moduleSourceChecks.add(new BNDDirectoryNameCheck());
        this._moduleSourceChecks.add(new BNDExportsCheck());
        this._moduleSourceChecks.add(new BNDIncludeResourceCheck());
        this._moduleSourceChecks.add(new BNDWebContextPathCheck());
    }

    @Override
    protected void populateSourceChecks() {
        this._sourceChecks.add(new BNDWhitespaceCheck());
        this._sourceChecks.add(new BNDCapabilityCheck());
        this._sourceChecks.add(new BNDDefinitionKeysCheck());
        this._sourceChecks.add(new BNDImportsCheck());
        this._sourceChecks.add(new BNDLineBreaksCheck());
        this._sourceChecks.add(new BNDRangeCheck());
        this._sourceChecks.add(new BNDSchemaVersionCheck());
        this._sourceChecks.add(new BNDStylingCheck());
    }
}

