/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.source.formatter.JavaClass;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterHelper;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.JavaTermCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.util.FileUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;
    protected static final String LANGUAGE_KEYS_CHECK_EXCLUDES = "language.keys.check.excludes";
    protected static final String METHOD_CALL_SORT_EXCLUDES = "method.call.sort.excludes";
    protected static final String RUN_OUTSIDE_PORTAL_EXCLUDES = "run.outside.portal.excludes";
    protected static Pattern emptyArrayPattern = Pattern.compile("((\\[\\])+) \\{\\}");
    protected static Pattern emptyCollectionPattern = Pattern.compile("Collections\\.EMPTY_(LIST|MAP|SET)");
    protected static Pattern getterUtilGetPattern = Pattern.compile("GetterUtil\\.get(Boolean|Double|Float|Integer|Number|Object|Short|String)\\((.*?)\\);\n", 32);
    protected static Pattern javaSourceInsideJSPLinePattern = Pattern.compile("<%=(.+?)%>");
    protected static boolean portalSource;
    protected static Pattern principalExceptionPattern;
    protected static Pattern sbAppendPattern;
    protected static Pattern sbAppendWithStartingSpacePattern;
    protected static boolean subrepository;
    protected SourceFormatterArgs sourceFormatterArgs;
    private static final String _DOCUMENTATION_URL = "https://github.com/liferay/liferay-portal/blob/master/modules/util/source-formatter/documentation/";
    private Set<String> _annotationsExclusions;
    private boolean _browserStarted;
    private Map<String, String> _compatClassNamesMap;
    private String[] _excludes;
    private Map<String, List<String>> _exclusionPropertiesMap = new HashMap<String, List<String>>();
    private SourceMismatchException _firstSourceMismatchException;
    private Set<String> _immutableFieldTypes;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private String _projectPathPrefix;
    private Properties _properties;
    private SourceFormatterHelper _sourceFormatterHelper;
    private Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();
    private boolean _usePortalCompatImport;

    @Override
    public final void format() throws Exception {
        List<String> fileNames;
        if (this.sourceFormatterArgs.isShowDocumentation()) {
            System.setProperty("java.awt.headless", "false");
        }
        if ((fileNames = this.getFileNames()).isEmpty()) {
            return;
        }
        this.preFormat();
        this.populateSourceChecks();
        if ((portalSource || subrepository) && this._containsModuleFile(fileNames)) {
            this.populateModuleSourceChecks();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(this.sourceFormatterArgs.getProcessorThreadCount());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(fileNames.size());
        for (final String string : fileNames) {
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        BaseSourceProcessor.this.format(string);
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to format " + string, e);
                    }
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        this.postFormat();
        this._sourceFormatterHelper.close();
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this.sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return fileNames;
        }
        return this.doGetFileNames();
    }

    @Override
    public SourceMismatchException getFirstSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    @Override
    public String[] getIncludes() {
        return this.filterIncludes(this.doGetIncludes());
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        TreeSet<SourceFormatterMessage> sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        for (Map.Entry<String, Set<SourceFormatterMessage>> entry : this._sourceFormatterMessagesMap.entrySet()) {
            sourceFormatterMessages.addAll((Collection<SourceFormatterMessage>)entry.getValue());
        }
        return sourceFormatterMessages;
    }

    @Override
    public void processMessage(String fileName, String message) {
        this.processMessage(fileName, message, -1);
    }

    @Override
    public void processMessage(String fileName, String message, int lineCount) {
        this.processMessage(fileName, message, null, lineCount);
    }

    @Override
    public void processMessage(String fileName, String message, String markdownFileName) {
        this.processMessage(fileName, message, markdownFileName, -1);
    }

    @Override
    public void processMessage(String fileName, String message, String markdownFileName, int lineCount) {
        this.processMessage(fileName, new SourceFormatterMessage(fileName, message, markdownFileName, lineCount));
    }

    @Override
    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this.sourceFormatterArgs = sourceFormatterArgs;
        this._init();
    }

    protected int adjustLevel(int level, String text, String s, int diff) {
        String[] lines;
        for (String line : lines = StringUtil.splitLines(text)) {
            if ((line = StringUtil.trim(line)).startsWith("//")) continue;
            int x = -1;
            while ((x = line.indexOf(s, x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                level += diff;
            }
        }
        return level;
    }

    protected void checkEmptyCollection(String line, String fileName, int lineCount) {
        Matcher matcher = emptyCollectionPattern.matcher(line);
        if (matcher.find()) {
            String collectionType = TextFormatter.format(matcher.group(1), 9);
            this.processMessage(fileName, "Use Collections.empty" + collectionType + "()", lineCount);
        }
    }

    protected void checkGetterUtilGet(String fileName, String content) throws Exception {
        Matcher matcher = getterUtilGetPattern.matcher(content);
        while (matcher.find()) {
            List<String> parametersList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (parametersList = this.getParameterList(matcher.group())).size() != 2) continue;
            String defaultVariableName = "DEFAULT_" + StringUtil.toUpperCase(matcher.group(1));
            Field defaultValuefield = GetterUtil.class.getDeclaredField(defaultVariableName);
            String defaultValue = String.valueOf(defaultValuefield.get(null));
            String value = parametersList.get(1);
            if (value.equals("StringPool.BLANK")) {
                value = "";
            }
            if (!Objects.equals(value, defaultValue)) continue;
            this.processMessage(fileName, "No need to pass default value '" + parametersList.get(1) + "'", this.getLineCount(content, matcher.start()));
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, int lineCount) {
        String methodName = "toLowerCase";
        int pos = line.indexOf(".toLowerCase()");
        if (pos == -1) {
            methodName = "toUpperCase";
            pos = line.indexOf(".toUpperCase()");
        }
        if (pos == -1 && !line.contains("StringUtil.equalsIgnoreCase(")) {
            methodName = "equalsIgnoreCase";
            pos = line.indexOf(".equalsIgnoreCase(");
        }
        if (pos != -1) {
            this.processMessage(fileName, "Use StringUtil." + methodName, lineCount);
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, String absolutePath, int lineCount, boolean javaSource) {
        if (this.isExcludedPath(RUN_OUTSIDE_PORTAL_EXCLUDES, absolutePath)) {
            return;
        }
        if (javaSource) {
            this.checkInefficientStringMethods(line, fileName, lineCount);
            return;
        }
        Matcher matcher = javaSourceInsideJSPLinePattern.matcher(line);
        while (matcher.find()) {
            this.checkInefficientStringMethods(matcher.group(1), fileName, lineCount);
        }
    }

    protected String checkPrincipalException(String content) {
        String newContent = content;
        Matcher matcher = principalExceptionPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "class.getName", "getNestedClasses");
            newContent = StringUtil.replace(newContent, match, replacement);
        }
        return newContent;
    }

    protected void checkPropertyUtils(String fileName, String content) {
        if (fileName.endsWith("TypeConvertorUtil.java")) {
            return;
        }
        if (content.contains("org.apache.commons.beanutils.PropertyUtils")) {
            this.processMessage(fileName, "Do not use org.apache.commons.beanutils.PropertyUtils, see LPS-62786");
        }
    }

    protected void checkUTF8(File file, String fileName) throws Exception {
        byte[] bytes = FileUtil.getBytes(file);
        try {
            CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder("UTF-8", CodingErrorAction.REPORT);
            charsetDecoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            this.processMessage(fileName, "UTF-8");
        }
    }

    protected abstract String doFormat(File var1, String var2, String var3, String var4) throws Exception;

    protected abstract List<String> doGetFileNames() throws Exception;

    protected abstract String[] doGetIncludes();

    protected String[] filterIncludes(String[] includes) {
        List<String> fileExtensions = this.sourceFormatterArgs.getFileExtensions();
        if (fileExtensions.isEmpty()) {
            return includes;
        }
        String[] filteredIncludes = new String[]{};
        for (String include : includes) {
            for (String fileExtension : fileExtensions) {
                if (!include.endsWith(fileExtension)) continue;
                filteredIncludes = ArrayUtil.append(filteredIncludes, include);
            }
        }
        return filteredIncludes;
    }

    protected String fixCompatClassImports(String absolutePath, String content) throws Exception {
        if (portalSource || subrepository || !this._usePortalCompatImport || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        Map<String, String> compatClassNamesMap = this.getCompatClassNamesMap();
        String newContent = content;
        for (Map.Entry<String, String> entry : compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(extendedClassName + "\\W");
            while ((matcher = pattern.matcher(newContent)).find()) {
                newContent = newContent.substring(0, matcher.start()) + compatClassName + newContent.substring(matcher.end() - 1);
            }
        }
        return newContent;
    }

    protected String fixIncorrectParameterTypeForLanguageUtil(String content, boolean autoFix, String fileName) {
        if (portalSource || subrepository) {
            return content;
        }
        String expectedParameter = this.getProperty("languageutil.expected.parameter");
        String incorrectParameter = this.getProperty("languageutil.incorrect.parameter");
        if (!content.contains("LanguageUtil.format(" + incorrectParameter + ", ") && !content.contains("LanguageUtil.get(" + incorrectParameter + ", ")) {
            return content;
        }
        if (autoFix) {
            content = StringUtil.replace(content, new String[]{"LanguageUtil.format(" + incorrectParameter + ", ", "LanguageUtil.get(" + incorrectParameter + ", "}, new String[]{"LanguageUtil.format(" + expectedParameter + ", ", "LanguageUtil.get(" + expectedParameter + ", "});
        } else {
            this.processMessage(fileName, "(Unicode)LanguageUtil.format/get methods require " + expectedParameter + " parameter instead of " + incorrectParameter);
        }
        return content;
    }

    protected final String format(File file, String fileName, String absolutePath, String content) throws Exception {
        this._sourceFormatterMessagesMap.remove(fileName);
        this.checkUTF8(file, fileName);
        if (!(this instanceof JavaSourceProcessor) && absolutePath.matches(".*\\/modules\\/.*\\/src\\/.*\\/java\\/.*")) {
            this.processMessage(fileName, "Only *.java files are allowed in /src/*/java/");
        }
        String newContent = this.processSourceChecks(fileName, absolutePath, content);
        newContent = this.doFormat(file, fileName, absolutePath, newContent);
        if (content.equals(newContent = StringUtil.replace(newContent, "\r", ""))) {
            return content;
        }
        return this.format(file, fileName, absolutePath, newContent);
    }

    protected final void format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            return;
        }
        fileName = StringUtil.replace(fileName, '\\', '/');
        String absolutePath = this.getAbsolutePath(fileName);
        File file = new File(absolutePath);
        String content = FileUtil.read(file);
        String newContent = this.format(file, fileName, absolutePath, content);
        this.processFormattedFile(file, fileName, content, newContent);
    }

    protected String formatEmptyArray(String line) {
        Matcher matcher = emptyArrayPattern.matcher(line);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(line, matcher.end(1))) continue;
            String replacement = StringUtil.replace(matcher.group(1), "[]", "[0]");
            return StringUtil.replaceFirst(line, matcher.group(), replacement, matcher.start());
        }
        return line;
    }

    protected String formatJavaTerms(String javaClassName, String packagePath, File file, String fileName, String absolutePath, String content, String javaClassContent, int javaClassLineCount, String indent, String checkJavaFieldTypesExcludesProperty, String javaTermSortExcludesProperty) throws Exception {
        JavaSourceProcessor javaSourceProcessor = null;
        if (this instanceof JavaSourceProcessor) {
            javaSourceProcessor = (JavaSourceProcessor)this;
        } else {
            javaSourceProcessor = new JavaSourceProcessor();
            javaSourceProcessor.setProperties(this._properties);
            javaSourceProcessor.setSourceFormatterArgs(this.sourceFormatterArgs);
        }
        JavaClass javaClass = new JavaClass(javaClassName, packagePath, file, fileName, absolutePath, content, javaClassContent, javaClassLineCount, indent + "\t", null, javaSourceProcessor);
        String newJavaClassContent = javaClass.formatJavaTerms(this.getAnnotationsExclusions(), this.getImmutableFieldTypes(), checkJavaFieldTypesExcludesProperty, javaTermSortExcludesProperty);
        if (!javaClassContent.equals(newJavaClassContent)) {
            return StringUtil.replaceFirst(content, javaClassContent, newJavaClassContent);
        }
        return content;
    }

    protected String formatStringBundler(String fileName, String content, int maxLineLength) {
        Matcher matcher = sbAppendPattern.matcher(content);
        block0: while (matcher.find()) {
            String[] appendValueParts;
            String appendValue = this.stripQuotes(matcher.group(2), '\"');
            if (!(appendValue = StringUtil.replace(appendValue, "+\n", "+ ")).contains(" + ")) continue;
            for (String appendValuePart : appendValueParts = StringUtil.split(appendValue, " + ")) {
                if (this.getLevel(appendValuePart) != 0 || Validator.isNumber(appendValuePart)) continue block0;
            }
            this.processMessage(fileName, "Incorrect use of '+' inside StringBundler", this.getLineCount(content, matcher.start(1)));
        }
        matcher = sbAppendWithStartingSpacePattern.matcher(content);
        while (matcher.find()) {
            String firstLine = matcher.group(1);
            if (firstLine.endsWith("\\n\");")) continue;
            if (maxLineLength != -1 && this.getLineLength(firstLine) >= maxLineLength) {
                this.processMessage(fileName, "Do not append string starting with space to StringBundler", this.getLineCount(content, matcher.start(3)));
                continue;
            }
            content = StringUtil.replaceFirst(content, "\");\n", " \");\n", matcher.start(2));
            content = StringUtil.replaceFirst(content, "(\" ", "(\"", matcher.start(3));
        }
        return content;
    }

    protected String getAbsolutePath(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    protected Set<String> getAnnotationsExclusions() {
        if (this._annotationsExclusions != null) {
            return this._annotationsExclusions;
        }
        this._annotationsExclusions = SetUtil.fromArray(new String[]{"ArquillianResource", "Autowired", "BeanReference", "Captor", "Inject", "Mock", "Parameter", "Reference", "ServiceReference", "SuppressWarnings", "Value"});
        return this._annotationsExclusions;
    }

    protected Map<String, String> getCompatClassNamesMap() throws Exception {
        if (this._compatClassNamesMap != null) {
            return this._compatClassNamesMap;
        }
        HashMap<String, String> compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**/portal-compat-shared/src/com/liferay/compat/**/*.java"};
        String basedir = this.sourceFormatterArgs.getBaseDirName();
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            File sharedDir = new File(basedir + "shared");
            if (sharedDir.exists()) {
                fileNames = this.getFileNames(basedir, new String[0], includes);
                break;
            }
            basedir = basedir + "../";
        }
        for (String fileName : fileNames) {
            File file = new File(fileName);
            String content = FileUtil.read(file);
            fileName = StringUtil.replace(fileName, '\\', '/');
            fileName = StringUtil.replace(fileName, '/', '.');
            int pos = fileName.indexOf("com.");
            String compatClassName = fileName.substring(pos);
            compatClassName = compatClassName.substring(0, compatClassName.length() - 5);
            String extendedClassName = StringUtil.replace(compatClassName, "compat.", "");
            if (!content.contains("extends " + extendedClassName)) continue;
            compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        this._compatClassNamesMap = compatClassNamesMap;
        return this._compatClassNamesMap;
    }

    protected String getContent(String fileName, int level) throws IOException {
        String content;
        File file = this.getFile(fileName, level);
        if (file != null && Validator.isNotNull(content = FileUtil.read(file))) {
            return content;
        }
        return "";
    }

    protected List<String> getExcludes(String property) {
        List<String> excludes = this._exclusionPropertiesMap.get(property);
        if (excludes != null) {
            return excludes;
        }
        excludes = this.getPropertyList(property);
        this._exclusionPropertiesMap.put(property, excludes);
        return excludes;
    }

    protected File getFile(String fileName, int level) {
        return this._sourceFormatterHelper.getFile(this.sourceFormatterArgs.getBaseDirName(), fileName, level);
    }

    protected List<String> getFileNames(String basedir, List<String> recentChangesFileNames, String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(basedir, recentChangesFileNames, excludes, includes, this.sourceFormatterArgs.isIncludeSubrepositories());
    }

    protected List<String> getFileNames(String basedir, List<String> recentChangesFileNames, String[] excludes, String[] includes, boolean includeSubrepositories) throws Exception {
        if (this._excludes != null) {
            excludes = ArrayUtil.append(excludes, this._excludes);
        }
        return this._sourceFormatterHelper.getFileNames(basedir, recentChangesFileNames, excludes, includes, includeSubrepositories);
    }

    protected List<String> getFileNames(String basedir, String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(basedir, this.sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), excludes, includes);
    }

    protected Set<String> getImmutableFieldTypes() {
        if (this._immutableFieldTypes != null) {
            return this._immutableFieldTypes;
        }
        Set<String> immutableFieldTypes = SetUtil.fromArray(new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "Boolean", "Byte", "Character", "Class", "Double", "Float", "Int", "Long", "Number", "Short", "String"});
        immutableFieldTypes.addAll(this.getPropertyList("immutable.field.types"));
        this._immutableFieldTypes = immutableFieldTypes;
        return this._immutableFieldTypes;
    }

    protected int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected int getLevel(String s) {
        return this.getLevel(s, new String[]{"("}, new String[]{")"}, 0);
    }

    protected int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return this.getLevel(s, new String[]{increaseLevelString}, new String[]{decreaseLevelString}, 0);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return this.getLevel(s, increaseLevelStrings, decreaseLevelStrings, 0);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        int level = startLevel;
        for (String increaseLevelString : increaseLevelStrings) {
            level = this.adjustLevel(level, s, increaseLevelString, 1);
        }
        for (String decreaseLevelString : decreaseLevelStrings) {
            level = this.adjustLevel(level, s, decreaseLevelString, -1);
        }
        return level;
    }

    protected String getLine(String content, int lineCount) {
        int nextLineStartPos = this.getLineStartPos(content, lineCount);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    protected int getLineCount(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        for (char c : line.toCharArray()) {
            if (c == '\t') {
                for (int i = 0; i < tabLength; ++i) {
                    ++lineLength;
                }
                tabLength = 4;
                continue;
            }
            ++lineLength;
            if (--tabLength > 0) continue;
            tabLength = 4;
        }
        return lineLength;
    }

    protected int getLineStartPos(String content, int lineCount) {
        int x = 0;
        for (int i = 1; i < lineCount; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    protected List<SourceCheck> getModuleSourceChecks() {
        return null;
    }

    protected List<String> getParameterList(String methodCall) {
        String parameters = null;
        int x = -1;
        while (this.getLevel(parameters = methodCall.substring(0, (x = methodCall.indexOf(")", x + 1)) + 1), "(", ")") != 0 || this.getLevel(parameters, "{", "}") != 0) {
        }
        x = parameters.indexOf("(");
        parameters = parameters.substring(x + 1, parameters.length() - 1);
        return this.splitParameters(parameters);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() throws Exception {
        if (this._pluginsInsideModulesDirectoryNames != null) {
            return this._pluginsInsideModulesDirectoryNames;
        }
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/private/apps/**/build.xml"});
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = this.getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, "\\", "/"));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        this._pluginsInsideModulesDirectoryNames = pluginsInsideModulesDirectoryNames;
        return this._pluginsInsideModulesDirectoryNames;
    }

    protected Properties getPortalLanguageProperties() throws Exception {
        Properties portalLanguageProperties = new Properties();
        File portalLanguagePropertiesFile = this.getFile("portal-impl/src/content/Language.properties", 7);
        if (portalLanguagePropertiesFile != null) {
            FileInputStream inputStream = new FileInputStream(portalLanguagePropertiesFile);
            portalLanguageProperties.load(inputStream);
        }
        return portalLanguageProperties;
    }

    protected String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    protected List<String> getPropertyList(String key) {
        return ListUtil.fromString(GetterUtil.getString(this.getProperty(key)), ",");
    }

    protected abstract List<SourceCheck> getSourceChecks();

    protected boolean isExcludedPath(String property, String path) {
        return this.isExcludedPath(property, path, -1);
    }

    protected boolean isExcludedPath(String property, String path, int lineCount) {
        return this.isExcludedPath(property, path, lineCount, null);
    }

    protected boolean isExcludedPath(String property, String path, int lineCount, String parameter) {
        if (property == null) {
            return false;
        }
        List<String> excludes = this._exclusionPropertiesMap.get(property);
        if (excludes == null) {
            excludes = this.getPropertyList(property);
            this._exclusionPropertiesMap.put(property, excludes);
        }
        if (ListUtil.isEmpty(excludes)) {
            return false;
        }
        String pathWithParameter = null;
        if (Validator.isNotNull(parameter)) {
            pathWithParameter = path + "@" + parameter;
        }
        String pathWithLineCount = null;
        if (lineCount > 0) {
            pathWithLineCount = path + "@" + lineCount;
        }
        for (String exclude : excludes) {
            if (Validator.isNull(exclude)) continue;
            if (exclude.startsWith("**")) {
                exclude = exclude.substring(2);
            }
            if (!(exclude.endsWith("**") ? path.contains(exclude = exclude.substring(0, exclude.length() - 2)) : path.endsWith(exclude) || pathWithParameter != null && pathWithParameter.endsWith(exclude) || pathWithLineCount != null && pathWithLineCount.endsWith(exclude))) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedPath(String property, String path, String parameter) {
        return this.isExcludedPath(property, path, -1, parameter);
    }

    protected boolean isModulesApp(String absolutePath, boolean privateOnly) {
        if (absolutePath.contains("/modules/private/apps/") || !privateOnly && absolutePath.contains("/modules/apps/")) {
            return true;
        }
        if (this._projectPathPrefix == null) {
            return false;
        }
        return this._projectPathPrefix.startsWith(":private:apps") || !privateOnly && this._projectPathPrefix.startsWith(":apps:");
    }

    protected boolean isModulesFile(String absolutePath) {
        return this.isModulesFile(absolutePath, false);
    }

    protected boolean isModulesFile(String absolutePath, boolean includePlugins) {
        if (subrepository) {
            return true;
        }
        if (includePlugins) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    protected abstract void populateSourceChecks() throws Exception;

    protected void populateModuleSourceChecks() throws Exception {
    }

    protected void postFormat() throws Exception {
    }

    protected void preFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        if (this.sourceFormatterArgs.isPrintErrors()) {
            this._sourceFormatterHelper.printError(fileName, message);
        }
    }

    protected String processSourceChecks(String fileName, String absolutePath, String content) throws Exception {
        content = this._processSourceChecks(fileName, absolutePath, content, this.getSourceChecks());
        if (this.isModulesFile(absolutePath)) {
            content = this._processSourceChecks(fileName, absolutePath, content, this.getModuleSourceChecks());
        }
        return content;
    }

    protected void processFormattedFile(File file, String fileName, String content, String newContent) throws Exception {
        Set<SourceFormatterMessage> sourceFormatterMessages;
        if (!content.equals(newContent)) {
            if (this.sourceFormatterArgs.isPrintErrors()) {
                this._sourceFormatterHelper.printError(fileName, file);
            }
            if (this.sourceFormatterArgs.isAutoFix()) {
                FileUtil.write(file, newContent);
            } else if (this._firstSourceMismatchException == null) {
                this._firstSourceMismatchException = new SourceMismatchException(fileName, content, newContent);
            }
        }
        if (this.sourceFormatterArgs.isPrintErrors() && (sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName)) != null) {
            for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
                String markdownFileName;
                this._sourceFormatterHelper.printError(fileName, sourceFormatterMessage.toString());
                if (this._browserStarted || !this.sourceFormatterArgs.isShowDocumentation() || !Desktop.isDesktopSupported() || !Validator.isNotNull(markdownFileName = sourceFormatterMessage.getMarkdownFileName())) continue;
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(_DOCUMENTATION_URL + markdownFileName));
                this._browserStarted = true;
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
    }

    protected void processMessage(String fileName, SourceFormatterMessage sourceFormatterMessage) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(sourceFormatterMessage);
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected Document readXML(String content) throws DocumentException {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read((Reader)new UnsyncStringReader(content));
    }

    protected String replacePrimitiveWrapperInstantiation(String line) {
        return StringUtil.replace(line, new String[]{"new Boolean(", "new Byte(", "new Character(", "new Double(", "new Float(", "new Integer(", "new Long(", "new Short("}, new String[]{"Boolean.valueOf(", "Byte.valueOf(", "Character.valueOf(", "Double.valueOf(", "Float.valueOf(", "Integer.valueOf(", "Long.valueOf(", "Short.valueOf("});
    }

    protected List<String> splitParameters(String parameters) {
        ArrayList<String> parametersList = new ArrayList<String>();
        int x = -1;
        while (true) {
            String linePart;
            if ((x = parameters.indexOf(",", x + 1)) == -1) {
                parametersList.add(StringUtil.trim(parameters));
                return parametersList;
            }
            if (ToolsUtil.isInsideQuotes(parameters, x) || this.getLevel(linePart = parameters.substring(0, x), "(", ")") != 0 || this.getLevel(linePart, "{", "}") != 0) continue;
            parametersList.add(StringUtil.trim(linePart));
            parameters = parameters.substring(x + 1);
            x = -1;
        }
    }

    protected String stripQuotes(String s) {
        return this.stripQuotes(s, '\'', '\"');
    }

    protected String stripQuotes(String s, char ... delimeters) {
        List<Character> delimetersList = ListUtil.toList(delimeters);
        char delimeter = ' ';
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideQuotes) {
                if (c != delimeter) continue;
                int precedingBackSlashCount = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++precedingBackSlashCount;
                }
                if (precedingBackSlashCount != 0 && precedingBackSlashCount % 2 != 0) continue;
                insideQuotes = false;
                continue;
            }
            if (delimetersList.contains(Character.valueOf(c))) {
                delimeter = c;
                insideQuotes = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean _containsModuleFile(List<String> fileNames) {
        for (String fileName : fileNames) {
            String absolutePath;
            if (!this._isMatchPath(fileName) || !this.isModulesFile(absolutePath = this.getAbsolutePath(fileName), true)) continue;
            return true;
        }
        return false;
    }

    private String[] _getExcludes() {
        if (this.sourceFormatterArgs.getFileNames() != null) {
            return new String[0];
        }
        List<String> excludesList = ListUtil.fromString(GetterUtil.getString(System.getProperty("source.formatter.excludes")));
        excludesList.addAll(this.getPropertyList("source.formatter.excludes"));
        return excludesList.toArray(new String[excludesList.size()]);
    }

    private String _getProjectPathPrefix() throws Exception {
        if (!subrepository) {
            return null;
        }
        File file = this.getFile("gradle.properties", 7);
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        return properties.getProperty("project.path.prefix");
    }

    private void _init() {
        try {
            this._sourceFormatterHelper = new SourceFormatterHelper(this.sourceFormatterArgs.isUseProperties());
            this._sourceFormatterHelper.init();
            portalSource = this._isPortalSource();
            subrepository = this._isSubrepository();
            this._projectPathPrefix = this._getProjectPathPrefix();
            this._sourceFormatterMessagesMap = new HashMap<String, Set<SourceFormatterMessage>>();
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
        this._excludes = this._getExcludes();
        this._usePortalCompatImport = GetterUtil.getBoolean(this.getProperty("use.portal.compat.import"));
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isPortalSource() {
        return this.getFile("portal-impl", 7) != null;
    }

    private boolean _isSubrepository() {
        String baseDirAbsolutePath = this.getAbsolutePath(this.sourceFormatterArgs.getBaseDirName());
        int x = baseDirAbsolutePath.length();
        for (int i = 0; i < 2; ++i) {
            if ((x = baseDirAbsolutePath.lastIndexOf(47, x - 1)) == -1) {
                return false;
            }
            String dirName = baseDirAbsolutePath.substring(x + 1);
            if (!dirName.startsWith("com-liferay-")) continue;
            return true;
        }
        return false;
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = originalPattern.replace('/', File.separatorChar);
        if ((pattern = pattern.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private String _processSourceChecks(String fileName, String absolutePath, String content, List<SourceCheck> sourceChecks) throws Exception {
        if (ListUtil.isEmpty(sourceChecks)) {
            return content;
        }
        com.liferay.source.formatter.parser.JavaClass javaClass = null;
        List<com.liferay.source.formatter.parser.JavaClass> anonymousClasses = null;
        for (SourceCheck sourceCheck : sourceChecks) {
            String newContent = null;
            if (sourceCheck instanceof FileCheck) {
                FileCheck fileCheck = (FileCheck)sourceCheck;
                newContent = fileCheck.process(fileName, absolutePath, content);
                for (SourceFormatterMessage sourceFormatterMessage : sourceCheck.getSourceFormatterMessage(fileName)) {
                    this.processMessage(fileName, sourceFormatterMessage);
                }
            } else if (sourceCheck instanceof JavaTermCheck && this instanceof JavaSourceProcessor) {
                JavaTermCheck javaTermCheck = (JavaTermCheck)sourceCheck;
                if (javaClass == null) {
                    anonymousClasses = JavaClassParser.parseAnonymousClasses(content);
                    javaClass = JavaClassParser.parseJavaClass(fileName, content);
                }
                newContent = javaTermCheck.process(fileName, absolutePath, javaClass, content);
                for (SourceFormatterMessage sourceFormatterMessage : sourceCheck.getSourceFormatterMessage(fileName)) {
                    this.processMessage(fileName, sourceFormatterMessage);
                }
                for (com.liferay.source.formatter.parser.JavaClass anonymousClass : anonymousClasses) {
                    newContent = javaTermCheck.process(fileName, absolutePath, anonymousClass, newContent);
                    for (SourceFormatterMessage sourceFormatterMessage : sourceCheck.getSourceFormatterMessage(fileName)) {
                        this.processMessage(fileName, sourceFormatterMessage);
                    }
                }
            }
            if (newContent.equals(content)) continue;
            return newContent;
        }
        return content;
    }

    static {
        principalExceptionPattern = Pattern.compile("SessionErrors\\.contains\\(\n?\t*(renderR|r)equest, PrincipalException\\.class\\.getName\\(\\)");
        sbAppendPattern = Pattern.compile("\\s*\\w*(sb|SB)[0-9]?\\.append\\(\\s*(\\S.*?)\\);\n", 32);
        sbAppendWithStartingSpacePattern = Pattern.compile("\n(\t*\\w*(sb|SB)[0-9]?\\.append\\(\".*\"\\);)\n\\s*\\w*(sb|SB)[0-9]?\\.append\\(\" .*\"\\);\n");
    }
}

