/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.JSPImportsFormatter;
import com.liferay.source.formatter.JSPSourceTabCalculator;
import com.liferay.source.formatter.checks.CopyrightCheck;
import com.liferay.source.formatter.checks.JSPDefineObjectsCheck;
import com.liferay.source.formatter.checks.JSPEmptyLinesCheck;
import com.liferay.source.formatter.checks.JSPIfStatementCheck;
import com.liferay.source.formatter.checks.JSPLanguageKeysCheck;
import com.liferay.source.formatter.checks.JSPLogFileNameCheck;
import com.liferay.source.formatter.checks.JSPModuleIllegalImportsCheck;
import com.liferay.source.formatter.checks.JSPRedirectBackURLCheck;
import com.liferay.source.formatter.checks.JSPSessionKeysCheck;
import com.liferay.source.formatter.checks.JSPStylingCheck;
import com.liferay.source.formatter.checks.JSPSubnameCheck;
import com.liferay.source.formatter.checks.JSPTagAttributesCheck;
import com.liferay.source.formatter.checks.JSPTaglibVariableCheck;
import com.liferay.source.formatter.checks.JSPUnusedImportCheck;
import com.liferay.source.formatter.checks.JSPUnusedTaglibCheck;
import com.liferay.source.formatter.checks.JSPUnusedVariableCheck;
import com.liferay.source.formatter.checks.JSPWhitespaceCheck;
import com.liferay.source.formatter.checks.JSPXSSVulnerabilitiesCheck;
import com.liferay.source.formatter.checks.MethodCallsOrderCheck;
import com.liferay.source.formatter.checks.ResourceBundleCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.StringUtilCheck;
import com.liferay.source.formatter.checks.UnparameterizedClassCheck;
import com.liferay.source.formatter.checks.ValidatorEqualsCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.ThreadSafeClassLibrary;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.jsp", "**/*.jspf", "**/*.tpl", "**/*.vm"};
    private static final String _UNUSED_VARIABLES_EXCLUDES = "jsp.unused.variables.excludes";
    private final Pattern _compressedJSPImportPattern = Pattern.compile("(<.*\n*page import=\".*>\n*)+", 8);
    private final Pattern _compressedJSPTaglibPattern = Pattern.compile("(<.*\n*taglib uri=\".*>\n*)+", 8);
    private Map<String, String> _contentsMap;
    private final Pattern _includeFilePattern = Pattern.compile("\\s*@\\s*include\\s*file=['\"](.*)['\"]");
    private Pattern _javaClassPattern = Pattern.compile("\n(private|protected|public).* class ([A-Za-z0-9]+) ([\\s\\S]*?)\n\\}\n");
    private final Pattern _jspIncludeFilePattern = Pattern.compile("/.*\\.(jsp[f]?|svg)");
    private final List<SourceCheck> _moduleSourceChecks = new ArrayList<SourceCheck>();
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();
    private final Pattern _uncompressedJSPImportPattern = Pattern.compile("(<.*page import=\".*>\n*)+", 8);
    private final Pattern _uncompressedJSPTaglibPattern = Pattern.compile("(<.*taglib uri=\".*>\n*)+", 8);

    protected String compressImportsOrTaglibs(String fileName, String content, String attributePrefix) {
        if (!fileName.endsWith("init.jsp") && !fileName.endsWith("init.jspf")) {
            return content;
        }
        int x = content.indexOf(attributePrefix);
        int y = content.lastIndexOf(attributePrefix);
        y = content.indexOf("%>", y);
        if (x == -1 || y == -1 || x > y) {
            return content;
        }
        String importsOrTaglibs = content.substring(x, y);
        importsOrTaglibs = StringUtil.replace(importsOrTaglibs, new String[]{"%>\r\n<%@ ", "%>\n<%@ "}, new String[]{"%><%@\r\n", "%><%@\n"});
        return content.substring(0, x) + importsOrTaglibs + content.substring(y);
    }

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = this.formatJSP(fileName, absolutePath, content);
        newContent = StringUtil.replace(newContent, new String[]{"<br/>", "@page import", "\"%>", ")%>", "function (", "javascript: ", "){\n", ";;\n"}, new String[]{"<br />", "@ page import", "\" %>", ") %>", "function(", "javascript:", ") {\n", ";\n"});
        newContent = this.fixCompatClassImports(absolutePath, newContent);
        newContent = this.formatJSPImportsOrTaglibs(fileName, newContent, this._compressedJSPImportPattern, this._uncompressedJSPImportPattern);
        newContent = this.formatJSPImportsOrTaglibs(fileName, newContent, this._compressedJSPTaglibPattern, this._uncompressedJSPTaglibPattern);
        if (!(!portalSource && !subrepository || !content.contains("page import=") || fileName.contains("init.jsp") || fileName.contains("init-ext.jsp") || fileName.contains("/taglib/aui/") || fileName.endsWith("touch.jsp") || !fileName.endsWith(".jspf") && !content.contains("include file="))) {
            this.processMessage(fileName, "Move imports to init.jsp");
        }
        newContent = this.compressImportsOrTaglibs(fileName, newContent, "<%@ page import=");
        newContent = this.compressImportsOrTaglibs(fileName, newContent, "<%@ taglib uri=");
        newContent = this.formatStringBundler(fileName, newContent, -1);
        newContent = this.fixIncorrectParameterTypeForLanguageUtil(newContent, true, fileName);
        newContent = this.checkPrincipalException(newContent);
        this.checkPropertyUtils(fileName, newContent);
        this.checkGetterUtilGet(fileName, newContent);
        Matcher matcher = this._javaClassPattern.matcher(newContent);
        if (matcher.find()) {
            String javaClassContent = matcher.group();
            javaClassContent = javaClassContent.substring(1);
            String javaClassName = matcher.group(2);
            int javaClassLineCount = this.getLineCount(newContent, matcher.start() + 1);
            newContent = this.formatJavaTerms(javaClassName, null, file, fileName, absolutePath, newContent, javaClassContent, javaClassLineCount, "", null, null);
        }
        JSPSourceTabCalculator jspSourceTabCalculator = new JSPSourceTabCalculator();
        newContent = jspSourceTabCalculator.calculateTabs(fileName, newContent, this);
        return newContent;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> fileNames = this.getFileNames(excludes, this.getIncludes());
        if (fileNames.isEmpty()) {
            return fileNames;
        }
        this._contentsMap = this._getContentsMap();
        if (this.sourceFormatterArgs.isFormatCurrentBranch() || this.sourceFormatterArgs.isFormatLatestAuthor() || this.sourceFormatterArgs.isFormatLocalChanges()) {
            return JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>(), this._contentsMap);
        }
        return fileNames;
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    protected String formatJSP(String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        String currentException = null;
        String previousException = null;
        boolean hasUnsortedExceptions = false;
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            String previousLine = "";
            boolean javaSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String includeFileName;
                Matcher matcher;
                int y;
                int x;
                ++lineCount;
                if (line.contains("<aui:button ") && line.contains("type=\"button\"")) {
                    this.processMessage(fileName, "No need to set 'type=button' for aui:button", lineCount);
                }
                if (line.contains("debugger.")) {
                    this.processMessage(fileName, "Do not use debugger", lineCount);
                }
                String trimmedLine = StringUtil.trimLeading(line);
                if (line.matches(".*\\WgetClass\\(\\)\\..+")) {
                    this.processMessage(fileName, "Avoid chaining on 'getClass'", lineCount);
                }
                this.checkEmptyCollection(trimmedLine, fileName, lineCount);
                line = this.formatEmptyArray(line);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                this.checkInefficientStringMethods(line, fileName, absolutePath, lineCount, javaSource);
                if (line.contains(".sendRedirect(") && !fileName.endsWith("_jsp.jsp")) {
                    this.processMessage(fileName, "Do not use sendRedirect in jsp, see LPS-47179", lineCount);
                }
                if (javaSource) {
                    line = StringUtil.replace(line, "LanguageUtil.get(locale,", "LanguageUtil.get(request,");
                } else {
                    Matcher matcher2 = javaSourceInsideJSPLinePattern.matcher(line);
                    while (matcher2.find()) {
                        String match = matcher2.group(1);
                        String replacement = StringUtil.replace(match, "LanguageUtil.get(locale,", "LanguageUtil.get(request,");
                        line = StringUtil.replace(line, match, replacement);
                    }
                }
                if (!fileName.endsWith("test.jsp") && line.contains("System.out.print")) {
                    this.processMessage(fileName, "Do not call 'System.out.print'", lineCount);
                }
                if (trimmedLine.matches("^\\} ?(catch|else|finally) .*")) {
                    this.processMessage(fileName, "There should be a line break after '}'", lineCount);
                }
                if (!hasUnsortedExceptions) {
                    int y2;
                    int x2 = line.indexOf("<liferay-ui:error exception=\"<%=");
                    if (x2 != -1 && (y2 = line.indexOf(".class %>", x2)) != -1) {
                        currentException = line.substring(x2, y2);
                        if (Validator.isNotNull(previousException) && previousException.compareToIgnoreCase(currentException) > 0) {
                            currentException = line;
                            previousException = previousLine;
                            hasUnsortedExceptions = true;
                        }
                    }
                    if (!hasUnsortedExceptions) {
                        previousException = currentException;
                        currentException = null;
                    }
                }
                if (!fileName.endsWith("/touch.jsp") && (x = line.indexOf("<%@ include file")) != -1 && (y = line.indexOf(34, (x = line.indexOf(34, x)) + 1)) != -1 && !(matcher = this._jspIncludeFilePattern.matcher(includeFileName = line.substring(x + 1, y))).find()) {
                    this.processMessage(fileName, "Incorrect include '" + includeFileName + "'", lineCount);
                }
                line = this.replacePrimitiveWrapperInstantiation(line);
                if (lineCount > 1) {
                    sb.append(previousLine);
                    sb.append("\n");
                }
                previousLine = line;
            }
            sb.append(previousLine);
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        if (hasUnsortedExceptions) {
            if (StringUtil.count(content, currentException) > 1 || StringUtil.count(content, previousException) > 1) {
                this.processMessage(fileName, "Unsorted exception '" + currentException + "'");
            } else {
                content = StringUtil.replaceFirst(content, previousException, currentException);
                content = StringUtil.replaceLast(content, currentException, previousException);
            }
        }
        return content;
    }

    protected String formatJSPImportsOrTaglibs(String fileName, String content, Pattern compressedPattern, Pattern uncompressedPattern) throws IOException {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = compressedPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        String newImports = StringUtil.replace(imports, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        content = StringUtil.replaceFirst(content, imports, newImports);
        JSPImportsFormatter importsFormatter = new JSPImportsFormatter();
        return importsFormatter.format(content, uncompressedPattern);
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected List<SourceCheck> getModuleSourceChecks() {
        return this._moduleSourceChecks;
    }

    @Override
    protected void populateSourceChecks() throws Exception {
        this._sourceChecks.add(new JSPWhitespaceCheck());
        this._sourceChecks.add(new CopyrightCheck(this.getContent(this.sourceFormatterArgs.getCopyrightFileName(), 7)));
        this._sourceChecks.add(new JSPDefineObjectsCheck(portalSource, subrepository, this.getPluginsInsideModulesDirectoryNames()));
        this._sourceChecks.add(new JSPEmptyLinesCheck());
        this._sourceChecks.add(new JSPIfStatementCheck());
        this._sourceChecks.add(new JSPLogFileNameCheck(subrepository));
        this._sourceChecks.add(new JSPRedirectBackURLCheck());
        this._sourceChecks.add(new JSPSessionKeysCheck());
        this._sourceChecks.add(new JSPStylingCheck());
        this._sourceChecks.add(new JSPSubnameCheck());
        this._sourceChecks.add(new JSPTagAttributesCheck(portalSource, subrepository, this._getPrimitiveTagAttributeDataTypes(), this._getTagJavaClassesMap()));
        this._sourceChecks.add(new JSPTaglibVariableCheck());
        this._sourceChecks.add(new JSPUnusedImportCheck(this._contentsMap));
        this._sourceChecks.add(new JSPXSSVulnerabilitiesCheck());
        this._sourceChecks.add(new MethodCallsOrderCheck(this.getExcludes("method.call.sort.excludes")));
        this._sourceChecks.add(new StringUtilCheck());
        this._sourceChecks.add(new UnparameterizedClassCheck());
        this._sourceChecks.add(new ValidatorEqualsCheck());
        if (portalSource || subrepository) {
            this._sourceChecks.add(new JSPUnusedTaglibCheck(this._contentsMap));
            this._sourceChecks.add(new JSPUnusedVariableCheck(this.getExcludes(_UNUSED_VARIABLES_EXCLUDES), this._contentsMap));
            this._sourceChecks.add(new ResourceBundleCheck(this.getExcludes("run.outside.portal.excludes")));
        }
        if (portalSource) {
            this._sourceChecks.add(new JSPLanguageKeysCheck(this.getExcludes("language.keys.check.excludes"), this.getPortalLanguageProperties()));
        }
    }

    @Override
    protected void populateModuleSourceChecks() throws Exception {
        this._moduleSourceChecks.add(new JSPModuleIllegalImportsCheck());
    }

    private Map<String, String> _getContentsMap() throws Exception {
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> allFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, excludes, this.getIncludes(), true);
        HashMap<String, String> contentsMap = new HashMap<String, String>();
        try {
            for (String fileName : allFileNames) {
                fileName = StringUtil.replace(fileName, '\\', '/');
                File file = new File(fileName);
                String content = FileUtil.read(file);
                Matcher matcher = this._includeFilePattern.matcher(content);
                String newContent = content;
                while (matcher.find()) {
                    newContent = StringUtil.replaceFirst(newContent, matcher.group(), "@ include file=\"" + matcher.group(1) + "\"", matcher.start());
                }
                this.processFormattedFile(file, fileName, content, newContent);
                contentsMap.put(fileName, newContent);
            }
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
        return contentsMap;
    }

    private Set<String> _getPrimitiveTagAttributeDataTypes() {
        return SetUtil.fromArray(new String[]{"boolean", "double", "int", "long"});
    }

    private Map<String, JavaClass> _getTagJavaClassesMap() throws Exception {
        HashMap<String, JavaClass> tagJavaClassesMap = new HashMap<String, JavaClass>();
        List<String> tldFileNames = this.getFileNames(this.sourceFormatterArgs.getBaseDirName(), null, new String[]{"**/dependencies/**", "**/util-taglib/**"}, new String[]{"**/*.tld"}, true);
        block2: for (String tldFileName : tldFileNames) {
            tldFileName = StringUtil.replace(tldFileName, '\\', '/');
            File tldFile = new File(tldFileName);
            String content = FileUtil.read(tldFile);
            Document document = this.readXML(content);
            Element rootElement = document.getRootElement();
            Element shortNameElement = rootElement.element("short-name");
            String shortName = shortNameElement.getStringValue();
            List tagElements = rootElement.elements("tag");
            String srcDir = null;
            for (Element tagElement : tagElements) {
                Element tagClassElement = tagElement.element("tag-class");
                String tagClassName = tagClassElement.getStringValue();
                if (!tagClassName.startsWith("com.liferay")) continue;
                if (srcDir == null) {
                    if (tldFileName.contains("/src/")) {
                        srcDir = tldFile.getAbsolutePath();
                        srcDir = StringUtil.replace(srcDir, '\\', '/');
                        srcDir = srcDir.substring(0, srcDir.lastIndexOf("/src/")) + "/src/main/java/";
                    } else {
                        srcDir = this._getUtilTaglibSrcDirName();
                        if (Validator.isNull(srcDir)) continue block2;
                    }
                }
                StringBundler sb = new StringBundler(3);
                sb.append(srcDir);
                sb.append(StringUtil.replace(tagClassName, '.', '/'));
                sb.append(".java");
                File tagJavaFile = new File(sb.toString());
                if (!tagJavaFile.exists()) continue;
                JavaDocBuilder javaDocBuilder = new JavaDocBuilder((DocletTagFactory)new DefaultDocletTagFactory(), (ClassLibrary)new ThreadSafeClassLibrary());
                try {
                    javaDocBuilder.addSource(tagJavaFile);
                }
                catch (ParseException pe) {
                    continue;
                }
                JavaClass tagJavaClass = javaDocBuilder.getClassByName(tagClassName);
                Element tagNameElement = tagElement.element("name");
                String tagName = tagNameElement.getStringValue();
                tagJavaClassesMap.put(shortName + ":" + tagName, tagJavaClass);
            }
        }
        return tagJavaClassesMap;
    }

    private String _getUtilTaglibSrcDirName() {
        File utilTaglibDir = this.getFile("util-taglib/src", 7);
        if (utilTaglibDir == null) {
            return "";
        }
        String utilTaglibSrcDirName = utilTaglibDir.getAbsolutePath();
        utilTaglibSrcDirName = StringUtil.replace(utilTaglibSrcDirName, '\\', '/');
        utilTaglibSrcDirName = utilTaglibSrcDirName + "/";
        return utilTaglibSrcDirName;
    }
}

