/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.LanguageKeysCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.js"};
    private final Pattern _multipleVarsOnSingleLinePattern = Pattern.compile("\t+var \\w+\\, ");
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher;
        String newContent = StringUtil.replace(content, new String[]{"\telse{", "\tfor(", "\tif(", "\twhile(", " function (", "){\n", "= new Array();", "= new Object();"}, new String[]{"\telse {", "\tfor (", "\tif (", "\twhile (", " function(", ") {\n", "= [];", "= {};"});
        while ((matcher = this._multipleVarsOnSingleLinePattern.matcher(newContent)).find()) {
            String match = matcher.group();
            int pos = match.indexOf("var ");
            StringBundler sb = new StringBundler(4);
            sb.append(match.substring(0, match.length() - 2));
            sb.append(";");
            sb.append("\n");
            sb.append(match.substring(0, pos + 4));
            newContent = StringUtil.replace(newContent, match, sb.toString());
        }
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        if (newContent.contains("debugger.")) {
            this.processMessage(fileName, "debugger");
        }
        return newContent;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/*.min.js", "**/*.nocsf.js", "**/*.soy.js", "**/aui/**", "**/jquery/**", "**/lodash/**", "**/misc/**", "**/r2.js", "**/tools/**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected void populateSourceChecks() throws Exception {
        this._sourceChecks.add(new WhitespaceCheck());
        if (portalSource) {
            this._sourceChecks.add(new LanguageKeysCheck(this.getExcludes("language.keys.check.excludes"), this.getPortalLanguageProperties()));
        }
    }
}

