/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseSourceCheck;
import com.liferay.source.formatter.checks.JavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;

public abstract class BaseJavaTermCheck
extends BaseSourceCheck
implements JavaTermCheck {
    protected static final String JAVA_CLASS = JavaClass.class.getName();
    protected static final String JAVA_CONSTRUCTOR = JavaConstructor.class.getName();
    protected static final String JAVA_METHOD = JavaMethod.class.getName();
    protected static final String JAVA_STATIC_BLOCK = JavaStaticBlock.class.getName();
    protected static final String JAVA_VARIABLE = JavaVariable.class.getName();

    @Override
    public String process(String fileName, String absolutePath, JavaClass javaClass, String content) throws Exception {
        this.clearSourceFormatterMessages(fileName);
        return this._walkJavaClass(fileName, absolutePath, javaClass, content, content);
    }

    protected abstract String doProcess(String var1, String var2, JavaTerm var3, String var4) throws Exception;

    protected abstract String[] getCheckableJavaTermNames();

    private boolean _isCheckableJavaTerm(JavaTerm javaTerm) {
        Class<?> clazz = javaTerm.getClass();
        String className = clazz.getName();
        for (String name : this.getCheckableJavaTermNames()) {
            if (!name.equals(className)) continue;
            return true;
        }
        return false;
    }

    private String _walkJavaClass(String fileName, String absolutePath, JavaClass javaClass, String parentContent, String fileContent) throws Exception {
        String javaClassContent;
        String newJavaClassContent = javaClassContent = javaClass.getContent();
        if (this._isCheckableJavaTerm(javaClass) && !javaClassContent.equals(newJavaClassContent = this.doProcess(fileName, absolutePath, javaClass, fileContent))) {
            return StringUtil.replace(parentContent, javaClassContent, newJavaClassContent);
        }
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            String newJavaTermContent;
            String javaTermContent;
            if (javaTerm instanceof JavaClass) {
                JavaClass childJavaClass = (JavaClass)javaTerm;
                newJavaClassContent = this._walkJavaClass(fileName, absolutePath, childJavaClass, javaClassContent, fileContent);
                if (newJavaClassContent.equals(javaClassContent)) continue;
                return StringUtil.replace(parentContent, javaClassContent, newJavaClassContent);
            }
            if (!this._isCheckableJavaTerm(javaTerm) || (javaTermContent = javaTerm.getContent()).equals(newJavaTermContent = this.doProcess(fileName, absolutePath, javaTerm, fileContent))) continue;
            newJavaClassContent = StringUtil.replace(javaClassContent, javaTermContent, newJavaTermContent);
            return StringUtil.replace(parentContent, javaClassContent, newJavaClassContent);
        }
        return parentContent;
    }
}

