/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EmptyLinesCheck
extends BaseFileCheck {
    private final Pattern _emptyLineBetweenTagsPattern = Pattern.compile("\n(\t*)</([-\\w:]+)>(\n*)(\t*)<([-\\w:]+)[> \n]");
    private final Pattern _emptyLineInMultiLineTagsPattern = Pattern.compile("\n\t*<[-\\w:#]+\n\n\t*\\w");
    private final Pattern _emptyLineInNestedTagsPattern1 = Pattern.compile("\n(\t*)(?:<\\w.*[^/])?>\n\n(\t*)(<.*)\n");
    private final Pattern _emptyLineInNestedTagsPattern2 = Pattern.compile("\n(\t*)(.*>)\n\n(\t*)</.*(\n|$)");
    private final Pattern _incorrectCloseCurlyBracePattern1 = Pattern.compile("\n(.+)\n\n(\t+)}\n");
    private final Pattern _incorrectCloseCurlyBracePattern2 = Pattern.compile("(\t| )@?(class|enum|interface|new)\\s");
    private final Pattern _missingEmptyLineBetweenTagsPattern1 = Pattern.compile("\n(\t*)/>\n(\t*)<[-\\w:]+[> \n]");
    private final Pattern _missingEmptyLineBetweenTagsPattern2 = Pattern.compile("\n(\t*)<.* />\n(\t*)<([-\\w:]+|\\w((?!</| />).)*[^/]>)\n");
    private final Pattern _missingEmptyLinePattern1 = Pattern.compile("(\t| = |return )new .*\\(.*\\) \\{\n\t+[^{\t]");
    private final Pattern _missingEmptyLinePattern2 = Pattern.compile("(\n\t*)(public|private|protected) [^;]+? \\{");
    private final Pattern _missingEmptyLinePattern3 = Pattern.compile("\n.*\\) \\{\n");
    private final Pattern _missingEmptyLinePattern4 = Pattern.compile("\n\t*// .*\n[\t ]*(?!// )\\S");
    private final Pattern _missingEmptyLinePattern5 = Pattern.compile("\n[\t ]*(?!// )\\S.*\n\t*// ");
    private final Pattern _missingEmptyLinePattern6 = Pattern.compile("[^{:/\n]\n\t*(for|if|try) \\(");
    private final Pattern _missingEmptyLinePattern7 = Pattern.compile("[\t\n]\\}\n[\t ]*(?!(/\\*|\\}|\\)|//|catch |else |finally |while ))\\S");
    private final Pattern _redundantEmptyLinePattern1 = Pattern.compile("\n\npublic ((abstract|static) )*(class|enum|interface) ");
    private final Pattern _redundantEmptyLinePattern2 = Pattern.compile(" \\* @author .*\n \\*\\/\n\n");
    private final Pattern _redundantEmptyLinePattern3 = Pattern.compile("[\n\t](catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private final Pattern _redundantEmptyLinePattern4 = Pattern.compile("\\{\n\n\t*\\}");
    private final Pattern _redundantEmptyLinePattern5 = Pattern.compile("\\}\n\n\t*(catch|else (if)?|finally) [\\(\\{]");
    private final Pattern _setVariablePattern = Pattern.compile("\t[A-Z]\\w+ (\\w+) =\\s+((?!\\{\n).)*?;\n", 32);

    protected String fixEmptyLinesBetweenTags(String content) {
        String tabs2;
        String tabs1;
        Matcher matcher = this._emptyLineBetweenTagsPattern.matcher(content);
        while (matcher.find()) {
            tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(4))) continue;
            String lineBreaks = matcher.group(3);
            String tagName1 = matcher.group(2);
            String tagName2 = matcher.group(5);
            if (tagName1.endsWith(":when") || tagName1.matches("dd|dt|li|span|td|th|tr") && tagName2.matches("dd|dt|li|span|td|th|tr")) {
                if (!lineBreaks.equals("\n\n")) continue;
                return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
            }
            if (!lineBreaks.equals("\n")) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = this._missingEmptyLineBetweenTagsPattern1.matcher(content);
        while (matcher.find()) {
            tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(2))) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        matcher = this._missingEmptyLineBetweenTagsPattern2.matcher(content);
        while (matcher.find()) {
            tabs1 = matcher.group(1);
            if (!tabs1.equals(tabs2 = matcher.group(2))) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(1));
        }
        return content;
    }

    protected String fixEmptyLinesInMultiLineTags(String content) {
        Matcher matcher = this._emptyLineInMultiLineTagsPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    protected String fixEmptyLinesInNestedTags(String content) {
        content = this.fixEmptyLinesInNestedTags(content, this._emptyLineInNestedTagsPattern1, true);
        return this.fixEmptyLinesInNestedTags(content, this._emptyLineInNestedTagsPattern2, false);
    }

    protected String fixEmptyLinesInNestedTags(String content, Pattern pattern, boolean startTag) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String tabs2 = null;
            if (startTag) {
                String secondLine = matcher.group(3);
                if (secondLine.equals("<%") || secondLine.startsWith("<%--") || secondLine.startsWith("<!--")) continue;
                tabs2 = matcher.group(2);
            } else {
                String firstLine = matcher.group(2);
                if (firstLine.equals("%>") || firstLine.endsWith("-->")) continue;
                tabs2 = matcher.group(3);
            }
            String tabs1 = matcher.group(1);
            if ((!startTag || tabs1.length() + 1 != tabs2.length()) && (startTag || tabs1.length() - 1 != tabs2.length())) continue;
            content = StringUtil.replaceFirst(content, "\n", "", matcher.end(1));
        }
        return content;
    }

    protected String fixIncorrectEmptyLineBeforeCloseCurlyBrace(String content) {
        Matcher matcher1 = this._incorrectCloseCurlyBracePattern1.matcher(content);
        while (matcher1.find()) {
            String lastLine;
            if (!this.isJavaSource(content, matcher1.end()) || (lastLine = StringUtil.trimLeading(matcher1.group(1))).startsWith("// ")) continue;
            String tabs = matcher1.group(2);
            int tabCount = tabs.length();
            int pos = matcher1.start();
            while (content.charAt((pos = content.lastIndexOf("\n" + tabs, pos - 1)) + tabCount + 1) == '\t') {
            }
            String codeBlock = content.substring(pos + 1, matcher1.end());
            String firstLine = codeBlock.substring(0, codeBlock.indexOf(10) + 1);
            Matcher matcher2 = this._incorrectCloseCurlyBracePattern2.matcher(firstLine);
            if (matcher2.find()) continue;
            return StringUtil.replaceFirst(content, "\n\n" + tabs + "}\n", "\n" + tabs + "}\n", pos);
        }
        return content;
    }

    protected String fixMissingEmptyLineAfterSettingVariable(String content) {
        Matcher matcher = this._setVariablePattern.matcher(content);
        while (matcher.find()) {
            int z;
            int y;
            if (!this.isJavaSource(content, matcher.start()) || content.charAt(matcher.end()) == '\n') continue;
            int x = content.indexOf(";\n", matcher.end());
            if (x == -1) {
                return content;
            }
            String nextCommand = content.substring(matcher.end(), x + 1);
            if (nextCommand.contains("{\n") || nextCommand.matches("\t*%>[\\S\\s]*")) continue;
            String variableName = matcher.group(1);
            Pattern pattern2 = Pattern.compile("\\W(" + variableName + ")\\.");
            Matcher matcher2 = pattern2.matcher(nextCommand);
            if (!matcher2.find() || ToolsUtil.isInsideQuotes(nextCommand, x = matcher2.start(1)) || (y = content.lastIndexOf("\ttry (", x += matcher.end())) != -1 && (z = content.indexOf(") {\n", y)) > x) continue;
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end(2));
        }
        return content;
    }

    protected String fixMissingEmptyLines(String content) {
        block0: while (true) {
            Matcher matcher = this._missingEmptyLinePattern1.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start()) || this.getLevel(matcher.group()) != 0) continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
                continue block0;
            }
            matcher = this._missingEmptyLinePattern2.matcher(content);
            while (matcher.find()) {
                String match;
                if (!this.isJavaSource(content, matcher.start()) || !(match = matcher.group()).contains("(")) continue;
                String whitespace = matcher.group(1);
                int x = content.indexOf(whitespace + "}" + "\n", matcher.end());
                int y = content.indexOf(whitespace + "}" + "\n\n", matcher.end());
                if (x == -1 || x == y) continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", x + 1);
                continue block0;
            }
            matcher = this._missingEmptyLinePattern3.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start()) || this.getLevel(matcher.group()) == 0 || content.charAt(matcher.end()) == '\n') continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.end() - 1);
                continue block0;
            }
            matcher = this._missingEmptyLinePattern4.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
                continue block0;
            }
            matcher = this._missingEmptyLinePattern5.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
                continue block0;
            }
            matcher = this._missingEmptyLinePattern6.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
                continue block0;
            }
            matcher = this._missingEmptyLinePattern7.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start() + 1);
                continue block0;
            }
            break;
        }
        return content;
    }

    protected String fixRedundantEmptyLines(String content) {
        block0: while (true) {
            Matcher matcher = this._redundantEmptyLinePattern1.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue block0;
            }
            matcher = this._redundantEmptyLinePattern2.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.end() - 1);
                continue block0;
            }
            matcher = this._redundantEmptyLinePattern3.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start() + 1);
                continue block0;
            }
            matcher = this._redundantEmptyLinePattern4.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue block0;
            }
            matcher = this._redundantEmptyLinePattern5.matcher(content);
            while (matcher.find()) {
                if (!this.isJavaSource(content, matcher.start())) continue;
                content = StringUtil.replaceFirst(content, "\n", "", matcher.start());
                continue block0;
            }
            break;
        }
        return content;
    }

    protected boolean isJavaSource(String content, int pos) {
        return true;
    }
}

