/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.JSPUnusedTermCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPUnusedImportCheck
extends JSPUnusedTermCheck {
    private final Pattern _compressedJSPImportPattern = Pattern.compile("(<.*\n*page import=\".*>\n*)+", 8);
    private final Map<String, String> _contentsMap;

    public JSPUnusedImportCheck(Map<String, String> contentsMap) {
        this._contentsMap = contentsMap;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this._contentsMap.isEmpty()) {
            content = this._removeUnusedImports(fileName, content);
        }
        return content;
    }

    private void _addJSPUnusedImports(String fileName, List<String> importLines, List<String> unneededImports) {
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        for (String importLine : importLines) {
            int x = importLine.indexOf(34);
            int y = importLine.indexOf(34, x + 1);
            if (x == -1 || y == -1) continue;
            String className = importLine.substring(x + 1, y);
            className = className.substring(className.lastIndexOf(46) + 1);
            String regex = "[^A-Za-z0-9_\"]" + className + "[^A-Za-z0-9_\"]";
            if (!this.hasUnusedJSPTerm(fileName, regex, "class", checkedFileNames, includeFileNames, this._contentsMap)) continue;
            unneededImports.add(importLine);
        }
    }

    private List<String> _getJSPDuplicateImports(String fileName, String content, List<String> importLines) {
        ArrayList<String> duplicateImports = new ArrayList<String>();
        for (String importLine : importLines) {
            int y;
            int x = content.indexOf("<%@ include file=");
            if (x == -1 || (y = content.indexOf("<%@ page import=")) == -1 || x >= y || !this._isJSPDuplicateImport(fileName, importLine, false)) continue;
            duplicateImports.add(importLine);
        }
        return duplicateImports;
    }

    private boolean _isJSPDuplicateImport(String fileName, String importLine, boolean checkFile) {
        String content = this._contentsMap.get(fileName);
        if (Validator.isNull(content)) {
            return false;
        }
        int x = importLine.indexOf("page");
        if (x == -1) {
            return false;
        }
        if (checkFile && content.contains(importLine.substring(x))) {
            return true;
        }
        int y = content.indexOf("<%@ include file=");
        if (y == -1) {
            return false;
        }
        if ((y = content.indexOf(34, y)) == -1) {
            return false;
        }
        int z = content.indexOf(34, y + 1);
        if (z == -1) {
            return false;
        }
        String includeFileName = content.substring(y + 1, z);
        includeFileName = JSPSourceUtil.buildFullPathIncludeFileName(fileName, includeFileName, this._contentsMap);
        return this._isJSPDuplicateImport(includeFileName, importLine, true);
    }

    private String _removeUnusedImports(String fileName, String content) throws Exception {
        if (fileName.endsWith("init-ext.jsp")) {
            return content;
        }
        Matcher matcher = this._compressedJSPImportPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        String newImports = StringUtil.replace(imports, new String[]{"<%@\r\n", "<%@\n", " %><%@ "}, new String[]{"\r\n<%@ ", "\n<%@ ", " %>\n<%@ "});
        ArrayList<String> importLines = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(newImports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            if (!line.contains("import=")) continue;
            importLines.add(line);
        }
        List<String> unneededImports = this._getJSPDuplicateImports(fileName, content, importLines);
        this._addJSPUnusedImports(fileName, importLines, unneededImports);
        for (String unneededImport : unneededImports) {
            newImports = StringUtil.replace(newImports, unneededImport, "");
        }
        return StringUtil.replaceFirst(content, imports, newImports);
    }
}

