/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.JSPUnusedTermCheck;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSPUnusedVariableCheck
extends JSPUnusedTermCheck {
    private final Map<String, String> _contentsMap;
    private final List<String> _excludes;

    public JSPUnusedVariableCheck(List<String> excludes, Map<String, String> contentsMap) {
        this._excludes = excludes;
        this._contentsMap = contentsMap;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this._contentsMap.isEmpty()) {
            return content;
        }
        HashSet<String> checkedFileNames = new HashSet<String>();
        HashSet<String> includeFileNames = new HashSet<String>();
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            boolean javaSource = false;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.equals("<%") || trimmedLine.equals("<%!")) {
                    javaSource = true;
                } else if (trimmedLine.equals("%>")) {
                    javaSource = false;
                }
                if (javaSource && !this.isExcludedPath(this._excludes, absolutePath, lineCount) && this._hasUnusedVariable(fileName, trimmedLine, checkedFileNames, includeFileNames)) continue;
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String _getVariableName(String line) {
        if (!line.endsWith(";") || line.startsWith("//")) {
            return null;
        }
        String variableName = null;
        int x = line.indexOf(" = ");
        if (x == -1) {
            int y = line.lastIndexOf(32);
            if (y != -1) {
                variableName = line.substring(y + 1, line.length() - 1);
            }
        } else {
            int y = (line = line.substring(0, x)).lastIndexOf(32);
            if (y != -1) {
                variableName = line.substring(y + 1);
            }
        }
        if (Validator.isVariableName(variableName)) {
            return variableName;
        }
        return null;
    }

    private boolean _hasUnusedVariable(String fileName, String line, Set<String> checkedFileNames, Set<String> includeFileNames) {
        if (line.contains(": ")) {
            return false;
        }
        String variableName = this._getVariableName(line);
        if (Validator.isNull(variableName) || variableName.equals("false") || variableName.equals("true")) {
            return false;
        }
        StringBundler sb = new StringBundler(6);
        sb.append("((/)|(\\*)|(\\+(\\+)?)|(-(-)?)|\\(|=)?( )?");
        sb.append(variableName);
        sb.append("( )?(\\.");
        sb.append("|(((\\+)|(-)|(\\*)|(/)|(%)|(\\|)|(&)|(\\^))?(=))");
        sb.append("|(\\+(\\+)?)|(-(-)?)");
        sb.append("|(\\)))?");
        return this.hasUnusedJSPTerm(fileName, sb.toString(), "variable", checkedFileNames, includeFileNames, this._contentsMap);
    }
}

