/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;

public class JavaXMLSecurityCheck
extends BaseFileCheck {
    private final List<String> _runOutsidePortalExcludes;
    private final List<String> _secureXMLExcludes;

    public JavaXMLSecurityCheck(List<String> runOutsidePortalExcludes, List<String> secureXMLExcludes) {
        this._runOutsidePortalExcludes = runOutsidePortalExcludes;
        this._secureXMLExcludes = secureXMLExcludes;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isExcludedPath(this._secureXMLExcludes, absolutePath) || fileName.contains("/test/") || fileName.contains("/testIntegration/")) {
            return content;
        }
        this._checkXMLSecurity(fileName, absolutePath, content);
        return content;
    }

    private void _checkXMLSecurity(String fileName, String absolutePath, String content) {
        String[] xmlVulnerabitilies = new String[]{"DocumentBuilderFactory.newInstance", "new javax.xml.parsers.SAXParser", "new org.apache.xerces.parsers.SAXParser", "new org.dom4j.io.SAXReader", "new SAXParser", "new SAXReader", "SAXParserFactory.newInstance", "saxParserFactory.newInstance", "SAXParserFactory.newSAXParser", "saxParserFactory.newSAXParser", "XMLInputFactory.newFactory", "xmlInputFactory.newFactory", "XMLInputFactory.newInstance", "xmlInputFactory.newInstance"};
        boolean runOutsidePortalExclusion = this.isExcludedPath(this._runOutsidePortalExcludes, absolutePath);
        for (String xmlVulnerabitily : xmlVulnerabitilies) {
            if (!content.contains(xmlVulnerabitily)) continue;
            StringBundler sb = new StringBundler(3);
            if (runOutsidePortalExclusion) {
                sb.append("Possible XXE or Quadratic Blowup security ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use SecureXMLFactoryProviderUtil.");
                sb.append("newDocumentBuilderFactory instead of ");
            }
            sb.append(xmlVulnerabitily);
            this.addMessage(fileName, sb.toString());
        }
    }
}

