/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bean;

import com.liferay.portal.kernel.bean.ConstantsBeanFactory;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentMap;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ConstantsBeanFactoryImpl
implements ConstantsBeanFactory {
    protected static ConcurrentMap<Class<?>, Object> constantsBeans = new ConcurrentReferenceKeyHashMap((ConcurrentMap)new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY), FinalizeManager.WEAK_REFERENCE_FACTORY);

    public Object getConstantsBean(Class<?> constantsClass) {
        Object constantsBean = constantsBeans.get(constantsClass);
        if (constantsBean == null) {
            constantsBean = ConstantsBeanFactoryImpl.createConstantsBean(constantsClass);
            constantsBeans.put(constantsClass, constantsBean);
        }
        return constantsBean;
    }

    protected static Object createConstantsBean(Class<?> constantsClass) {
        ClassLoader classLoader = constantsClass.getClassLoader();
        String constantsBeanClassName = constantsClass.getName() + "Bean";
        Class constantsBeanClass = null;
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            try {
                constantsBeanClass = classLoader.loadClass(constantsBeanClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                if (constantsBeanClass == null) {
                    Method defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
                    byte[] classData = ConstantsBeanFactoryImpl.generateConstantsBeanClassData(constantsClass);
                    constantsBeanClass = (Class)defineClassMethod.invoke((Object)classLoader, constantsBeanClassName, classData, 0, classData.length);
                }
                return constantsBeanClass.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    protected static byte[] generateConstantsBeanClassData(Class<?> constantsClass) {
        Field[] fields;
        String constantsClassBinaryName = ConstantsBeanFactoryImpl.getClassBinaryName(constantsClass);
        String constantsBeanClassBinaryName = constantsClassBinaryName + "Bean";
        String objectClassBinaryName = ConstantsBeanFactoryImpl.getClassBinaryName(Object.class);
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(50, 33, constantsBeanClassBinaryName, null, objectClassBinaryName, null);
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "()V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, objectClassBinaryName, "<init>", "()V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(1, 1);
        methodVisitor.visitEnd();
        for (Field field : fields = constantsClass.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            Type fieldType = Type.getType(field.getType());
            methodVisitor = classWriter.visitMethod(1, "get" + field.getName(), "()" + fieldType.getDescriptor(), null, null);
            methodVisitor.visitCode();
            methodVisitor.visitFieldInsn(178, constantsClassBinaryName, field.getName(), fieldType.getDescriptor());
            methodVisitor.visitInsn(fieldType.getOpcode(172));
            methodVisitor.visitMaxs(fieldType.getSize(), 1);
            methodVisitor.visitEnd();
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    protected static String getClassBinaryName(Class<?> clazz) {
        String className = clazz.getName();
        return className.replace('.', '/');
    }
}

