/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.configuration;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.registry.util.StringPlus;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseEditorConfigurationProvider<T> {
    protected static String getKey(String portletName, String editorConfigKey, String editorName) {
        if (Validator.isNull((String)portletName)) {
            portletName = "null";
        }
        if (Validator.isNull((String)editorConfigKey)) {
            editorConfigKey = "null";
        }
        if (Validator.isNull((String)editorName)) {
            editorName = "null";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(portletName);
        sb.append(".");
        sb.append(editorConfigKey);
        sb.append(".");
        sb.append(editorName);
        return sb.toString();
    }

    protected List<T> getContributors(String portletName, String editorConfigKey, String editorName) {
        ArrayList contributors = new ArrayList();
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(portletName, editorConfigKey, editorName));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(portletName, editorConfigKey, null));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(null, editorConfigKey, editorName));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(portletName, null, editorName));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(null, editorConfigKey, null));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(portletName, null, null));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(null, null, editorName));
        this.populateContributor(contributors, BaseEditorConfigurationProvider.getKey(null, null, null));
        return contributors;
    }

    protected abstract ServiceTrackerMap<String, List<T>> getServiceTrackerMap();

    protected void populateContributor(List<T> contributors, String key) {
        ServiceTrackerMap<String, List<T>> serviceTrackerMap = this.getServiceTrackerMap();
        List curContributors = (List)serviceTrackerMap.getService((Object)key);
        if (ListUtil.isNotEmpty((List)curContributors)) {
            contributors.addAll(curContributors);
        }
    }

    protected static class EditorServiceReferenceMapper<T>
    implements ServiceReferenceMapper<String, T> {
        protected EditorServiceReferenceMapper() {
        }

        public void map(ServiceReference<T> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            List editorNames;
            List editorConfigKeys;
            List portletNames = StringPlus.asList((Object)serviceReference.getProperty("javax.portlet.name"));
            if (portletNames.isEmpty()) {
                portletNames.add("");
            }
            if ((editorConfigKeys = StringPlus.asList((Object)serviceReference.getProperty("editor.config.key"))).isEmpty()) {
                editorConfigKeys.add("");
            }
            if ((editorNames = StringPlus.asList((Object)serviceReference.getProperty("editor.name"))).isEmpty()) {
                editorNames.add("");
            }
            for (String portletName : portletNames) {
                for (String editorConfigKey : editorConfigKeys) {
                    for (String editorName : editorNames) {
                        emitter.emit((Object)BaseEditorConfigurationProvider.getKey(portletName, editorConfigKey, editorName));
                    }
                }
            }
        }
    }
}

