/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LayoutTypeControllerImpl
implements LayoutTypeController {
    private final boolean _browsable;
    private final String[] _configurationActionDelete;
    private final String[] _configurationActionUpdate;
    private final String _editPage;
    private final boolean _firstPageable;
    private final boolean _fullPageDisplayable;
    private final boolean _parentable;
    private final boolean _sitemapable;
    private final String _type;
    private final String _url;
    private final boolean _urlFriendliable;
    private final String _viewPage;

    public LayoutTypeControllerImpl(String type) {
        this._type = type;
        Filter filter = new Filter(type);
        this._browsable = GetterUtil.getBoolean((String)PropsUtil.get("layout.browsable", filter), (boolean)true);
        this._configurationActionDelete = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.delete", filter)));
        this._configurationActionUpdate = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.update", filter)));
        this._editPage = GetterUtil.getString((String)PropsUtil.get("layout.edit.page", filter));
        this._firstPageable = GetterUtil.getBoolean((String)PropsUtil.get("layout.first.pageable", filter));
        this._fullPageDisplayable = GetterUtil.getBoolean((String)PropsUtil.get("full.page.displayable", filter));
        this._parentable = GetterUtil.getBoolean((String)PropsUtil.get("layout.parentable", filter), (boolean)true);
        this._sitemapable = GetterUtil.getBoolean((String)PropsUtil.get("layout.sitemapable", filter), (boolean)true);
        this._url = GetterUtil.getString((String)PropsUtil.get("layout.url", filter));
        this._urlFriendliable = GetterUtil.getBoolean((String)PropsUtil.get("layout.url.friendliable", filter), (boolean)true);
        this._viewPage = GetterUtil.getString((String)PropsUtil.get("layout.view.page", filter));
    }

    public String[] getConfigurationActionDelete() {
        return this._configurationActionDelete;
    }

    public String[] getConfigurationActionUpdate() {
        return this._configurationActionUpdate;
    }

    public String getType() {
        return this._type;
    }

    public String getURL() {
        return this._url;
    }

    public String getViewPath(String portletId) {
        String path = "/html";
        path = Validator.isNotNull((String)portletId) ? (this._type.equals("panel") ? path + "/portal/layout/view/panel.jsp" : path + "/portal/layout/view/portlet.jsp") : "/html" + this._viewPage;
        return path;
    }

    public String includeEditContent(HttpServletRequest request, HttpServletResponse response, Layout layout) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)servletContext, (String)this.getEditPage());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        requestDispatcher.include((ServletRequest)request, (ServletResponse)pipingServletResponse);
        return unsyncStringWriter.toString();
    }

    public boolean includeLayoutContent(HttpServletRequest request, HttpServletResponse response, Layout layout) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        String path = this.getViewPath(portletId);
        RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)servletContext, (String)path);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        String contentType = pipingServletResponse.getContentType();
        requestDispatcher.include((ServletRequest)request, (ServletResponse)pipingServletResponse);
        if (contentType != null) {
            response.setContentType(contentType);
        }
        request.setAttribute("LAYOUT_CONTENT", (Object)unsyncStringWriter.getStringBundler());
        return false;
    }

    public boolean isBrowsable() {
        return this._browsable;
    }

    public boolean isCheckLayoutViewPermission() {
        return true;
    }

    public boolean isFirstPageable() {
        return this._firstPageable;
    }

    public boolean isFullPageDisplayable() {
        return this._fullPageDisplayable;
    }

    public boolean isInstanceable() {
        return true;
    }

    public boolean isParentable() {
        return this._parentable;
    }

    public boolean isSitemapable() {
        return this._sitemapable;
    }

    public boolean isURLFriendliable() {
        return this._urlFriendliable;
    }

    public boolean matches(HttpServletRequest request, String friendlyURL, Layout layout) {
        try {
            Map friendlyURLMap = layout.getFriendlyURLMap();
            Collection values = friendlyURLMap.values();
            return values.contains(friendlyURL);
        }
        catch (SystemException se) {
            throw new RuntimeException(se);
        }
    }

    protected String getEditPage() {
        return "/html" + this._editPage;
    }
}

