/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.kernel.security.pwd.PasswordEncryptor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.pwd.BasePasswordEncryptor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.util.BCrypt;

public class BCryptPasswordEncryptor
extends BasePasswordEncryptor
implements PasswordEncryptor {
    private static final int _ROUNDS = 10;
    private static final Pattern _pattern = Pattern.compile("^BCrypt/([0-9]+)$", 2);

    public String[] getSupportedAlgorithmTypes() {
        return new String[]{"BCRYPT"};
    }

    @Override
    protected String doEncrypt(String algorithm, String plainTextPassword, String encryptedPassword) {
        String salt = null;
        if (Validator.isNull((String)encryptedPassword)) {
            int rounds = 10;
            Matcher matcher = _pattern.matcher(algorithm);
            if (matcher.matches()) {
                rounds = GetterUtil.getInteger((String)matcher.group(1), (int)rounds);
            }
            salt = BCrypt.gensalt((int)rounds);
        } else {
            salt = encryptedPassword.substring(0, 29);
        }
        return BCrypt.hashpw((String)plainTextPassword, (String)salt);
    }
}

