/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.base.MembershipRequestServiceBaseImpl;

public class MembershipRequestServiceImpl
extends MembershipRequestServiceBaseImpl {
    public MembershipRequest addMembershipRequest(long groupId, String comments, ServiceContext serviceContext) throws PortalException {
        return this.membershipRequestLocalService.addMembershipRequest(this.getUserId(), groupId, comments, serviceContext);
    }

    public void deleteMembershipRequests(long groupId, long statusId) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.membershipRequestLocalService.deleteMembershipRequests(groupId, statusId);
    }

    public MembershipRequest getMembershipRequest(long membershipRequestId) throws PortalException {
        MembershipRequest membershipRequest = this.membershipRequestLocalService.getMembershipRequest(membershipRequestId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)membershipRequest.getGroupId(), (String)"ASSIGN_MEMBERS");
        return membershipRequest;
    }

    public void updateStatus(long membershipRequestId, String reviewComments, long statusId, ServiceContext serviceContext) throws PortalException {
        MembershipRequest membershipRequest = this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)membershipRequest.getGroupId(), (String)"ASSIGN_MEMBERS");
        this.membershipRequestLocalService.updateStatus(this.getUserId(), membershipRequestId, reviewComments, statusId, true, serviceContext);
    }
}

