/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.AddressPersistence;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.impl.AddressImpl;
import com.liferay.portal.model.impl.AddressModelImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class AddressPersistenceImpl
extends BasePersistenceImpl<Address>
implements AddressPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AddressImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 192L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "address.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "address.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(address.uuid IS NULL OR address.uuid = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 196L);
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_UUID_C_UUID_1 = "address.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "address.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(address.uuid IS NULL OR address.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "address.companyId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_COMPANYID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 132L);
    public static final FinderPath FINDER_PATH_COUNT_BY_COMPANYID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "address.companyId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_USERID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 160L);
    public static final FinderPath FINDER_PATH_COUNT_BY_USERID = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "address.userId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 133L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_C_C_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "address.classNameId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()}, 135L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_C_C = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_C_C_C_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_CLASSNAMEID_2 = "address.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_CLASSPK_2 = "address.classPK = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C_C_M = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C_M", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_M = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C_M", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, 143L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_C_C_M = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C_M", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()});
    private static final String _FINDER_COLUMN_C_C_C_M_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_M_CLASSNAMEID_2 = "address.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_M_CLASSPK_2 = "address.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_M_MAILING_2 = "address.mailing = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C_C_P = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_C_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_P = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, AddressImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_C_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, 151L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_C_C_P = new FinderPath(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C_C_P", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Boolean.class.getName()});
    private static final String _FINDER_COLUMN_C_C_C_P_COMPANYID_2 = "address.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_P_CLASSNAMEID_2 = "address.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_P_CLASSPK_2 = "address.classPK = ? AND ";
    private static final String _FINDER_COLUMN_C_C_C_P_PRIMARY_2 = "address.primary = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    protected EntityCache entityCache = EntityCacheUtil.getEntityCache();
    protected FinderCache finderCache = FinderCacheUtil.getFinderCache();
    private static final String _SQL_SELECT_ADDRESS = "SELECT address FROM Address address";
    private static final String _SQL_SELECT_ADDRESS_WHERE_PKS_IN = "SELECT address FROM Address address WHERE addressId IN (";
    private static final String _SQL_SELECT_ADDRESS_WHERE = "SELECT address FROM Address address WHERE ";
    private static final String _SQL_COUNT_ADDRESS = "SELECT COUNT(address) FROM Address address";
    private static final String _SQL_COUNT_ADDRESS_WHERE = "SELECT COUNT(address) FROM Address address WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "address.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Address exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Address exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AddressPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "primary"});

    public List<Address> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<Address> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<Address> findByUuid(String uuid, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<Address> findByUuid(String uuid, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (Objects.equals(uuid, address.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByUuid_First(String uuid, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_First(uuid, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByUuid_First(String uuid, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByUuid_Last(String uuid, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_Last(uuid, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByUuid_Last(String uuid, OrderByComparator<Address> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByUuid_PrevAndNext(long addressId, String uuid, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByUuid_PrevAndNext(session, address, uuid, orderByComparator, true), address, this.getByUuid_PrevAndNext(session, address, uuid, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByUuid_PrevAndNext(Session session, Address address, String uuid, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (Address address : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByUuid(String uuid) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<Address> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<Address> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<Address> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_UUID_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (Objects.equals(uuid, address.getUuid()) && companyId == address.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("address.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByUuid_C_First(String uuid, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByUuid_C_Last(String uuid, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("uuid=");
        msg.append(uuid);
        msg.append(", companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByUuid_C_PrevAndNext(long addressId, String uuid, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByUuid_C_PrevAndNext(session, address, uuid, companyId, orderByComparator, true), address, this.getByUuid_C_PrevAndNext(session, address, uuid, companyId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByUuid_C_PrevAndNext(Session session, Address address, String uuid, long companyId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        boolean bindUuid = false;
        if (uuid == null) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_1);
        } else if (uuid.equals("")) {
            query.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            query.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        query.append("address.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        if (bindUuid) {
            qPos.add(uuid);
        }
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (Address address : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_UUID_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            boolean bindUuid = false;
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                query.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            query.append("address.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindUuid) {
                    qPos.add(uuid);
                }
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<Address> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<Address> findByCompanyId(long companyId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<Address> findByCompanyId(long companyId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_COMPANYID;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByCompanyId_First(long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByCompanyId_First(long companyId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByCompanyId_Last(long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByCompanyId_Last(long companyId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByCompanyId_PrevAndNext(long addressId, long companyId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByCompanyId_PrevAndNext(session, address, companyId, orderByComparator, true), address, this.getByCompanyId_PrevAndNext(session, address, companyId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByCompanyId_PrevAndNext(Session session, Address address, long companyId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (Address address : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_COMPANYID;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<Address> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<Address> findByUserId(long userId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<Address> findByUserId(long userId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID;
            finderArgs = new Object[]{userId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_USERID;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (userId == address.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByUserId_First(long userId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUserId_First(userId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByUserId_First(long userId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByUserId_Last(long userId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByUserId_Last(userId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("userId=");
        msg.append(userId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByUserId_Last(long userId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByUserId_PrevAndNext(long addressId, long userId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByUserId_PrevAndNext(session, address, userId, orderByComparator, true), address, this.getByUserId_PrevAndNext(session, address, userId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByUserId_PrevAndNext(Session session, Address address, long userId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(userId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (Address address : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_USERID;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(userId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByC_C(long companyId, long classNameId) {
        return this.findByC_C(companyId, classNameId, -1, -1, null);
    }

    public List<Address> findByC_C(long companyId, long classNameId, int start, int end) {
        return this.findByC_C(companyId, classNameId, start, end, null);
    }

    public List<Address> findByC_C(long companyId, long classNameId, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C(companyId, classNameId, start, end, orderByComparator, true);
    }

    public List<Address> findByC_C(long companyId, long classNameId, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C;
            finderArgs = new Object[]{companyId, classNameId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C;
            finderArgs = new Object[]{companyId, classNameId, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByC_C_First(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_First(companyId, classNameId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_First(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C(companyId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByC_C_Last(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_Last(companyId, classNameId, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_Last(long companyId, long classNameId, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C(companyId, classNameId);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C(companyId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByC_C_PrevAndNext(long addressId, long companyId, long classNameId, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_PrevAndNext(session, address, companyId, classNameId, orderByComparator, true), address, this.getByC_C_PrevAndNext(session, address, companyId, classNameId, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_PrevAndNext(Session session, Address address, long companyId, long classNameId, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(classNameId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByC_C(long companyId, long classNameId) {
        for (Address address : this.findByC_C(companyId, classNameId, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByC_C(long companyId, long classNameId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_C;
        Object[] finderArgs = new Object[]{companyId, classNameId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_CLASSNAMEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK) {
        return this.findByC_C_C(companyId, classNameId, classPK, -1, -1, null);
    }

    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK, int start, int end) {
        return this.findByC_C_C(companyId, classNameId, classPK, start, end, null);
    }

    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C_C(companyId, classNameId, classPK, start, end, orderByComparator, true);
    }

    public List<Address> findByC_C_C(long companyId, long classNameId, long classPK, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C;
            finderArgs = new Object[]{companyId, classNameId, classPK};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C_C;
            finderArgs = new Object[]{companyId, classNameId, classPK, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId() && classPK == address.getClassPK()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByC_C_C_First(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_First(companyId, classNameId, classPK, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_C_First(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C_C(companyId, classNameId, classPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByC_C_C_Last(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_Last(companyId, classNameId, classPK, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_C_Last(long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C_C(companyId, classNameId, classPK);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C_C(companyId, classNameId, classPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByC_C_C_PrevAndNext(long addressId, long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_C_PrevAndNext(session, address, companyId, classNameId, classPK, orderByComparator, true), address, this.getByC_C_C_PrevAndNext(session, address, companyId, classNameId, classPK, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_C_PrevAndNext(Session session, Address address, long companyId, long classNameId, long classPK, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append("address.classNameId = ? AND ");
        query.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByC_C_C(long companyId, long classNameId, long classPK) {
        for (Address address : this.findByC_C_C(companyId, classNameId, classPK, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByC_C_C(long companyId, long classNameId, long classPK) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_C_C;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing) {
        return this.findByC_C_C_M(companyId, classNameId, classPK, mailing, -1, -1, null);
    }

    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing, int start, int end) {
        return this.findByC_C_C_M(companyId, classNameId, classPK, mailing, start, end, null);
    }

    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C_C_M(companyId, classNameId, classPK, mailing, start, end, orderByComparator, true);
    }

    public List<Address> findByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_M;
            finderArgs = new Object[]{companyId, classNameId, classPK, mailing};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C_C_M;
            finderArgs = new Object[]{companyId, classNameId, classPK, mailing, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId() && classPK == address.getClassPK() && mailing == address.getMailing()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_M_MAILING_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(mailing);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByC_C_C_M_First(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_M_First(companyId, classNameId, classPK, mailing, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", mailing=");
        msg.append(mailing);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_C_M_First(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C_C_M(companyId, classNameId, classPK, mailing, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByC_C_C_M_Last(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_M_Last(companyId, classNameId, classPK, mailing, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", mailing=");
        msg.append(mailing);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_C_M_Last(long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C_C_M(companyId, classNameId, classPK, mailing);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C_C_M(companyId, classNameId, classPK, mailing, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByC_C_C_M_PrevAndNext(long addressId, long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_C_M_PrevAndNext(session, address, companyId, classNameId, classPK, mailing, orderByComparator, true), address, this.getByC_C_C_M_PrevAndNext(session, address, companyId, classNameId, classPK, mailing, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_C_M_PrevAndNext(Session session, Address address, long companyId, long classNameId, long classPK, boolean mailing, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append("address.classNameId = ? AND ");
        query.append("address.classPK = ? AND ");
        query.append(_FINDER_COLUMN_C_C_C_M_MAILING_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        qPos.add(mailing);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing) {
        for (Address address : this.findByC_C_C_M(companyId, classNameId, classPK, mailing, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByC_C_C_M(long companyId, long classNameId, long classPK, boolean mailing) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_C_C_M;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK, mailing};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_M_MAILING_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(mailing);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary) {
        return this.findByC_C_C_P(companyId, classNameId, classPK, primary, -1, -1, null);
    }

    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary, int start, int end) {
        return this.findByC_C_C_P(companyId, classNameId, classPK, primary, start, end, null);
    }

    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary, int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findByC_C_C_P(companyId, classNameId, classPK, primary, start, end, orderByComparator, true);
    }

    public List<Address> findByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary, int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_P;
            finderArgs = new Object[]{companyId, classNameId, classPK, primary};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_C_C_C_P;
            finderArgs = new Object[]{companyId, classNameId, classPK, primary, start, end, orderByComparator};
        }
        List<Address> list = null;
        if (retrieveFromCache && (list = (List<Address>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Address address : list) {
                if (companyId == address.getCompanyId() && classNameId == address.getClassNameId() && classPK == address.getClassPK() && primary == address.getPrimary()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_P_PRIMARY_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY address.createDate ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(primary);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Address findByC_C_C_P_First(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_P_First(companyId, classNameId, classPK, primary, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", primary=");
        msg.append(primary);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_C_P_First(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) {
        List<Address> list = this.findByC_C_C_P(companyId, classNameId, classPK, primary, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address findByC_C_C_P_Last(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.fetchByC_C_C_P_Last(companyId, classNameId, classPK, primary, orderByComparator);
        if (address != null) {
            return address;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", classPK=");
        msg.append(classPK);
        msg.append(", primary=");
        msg.append(primary);
        msg.append("}");
        throw new NoSuchAddressException(msg.toString());
    }

    public Address fetchByC_C_C_P_Last(long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) {
        int count = this.countByC_C_C_P(companyId, classNameId, classPK, primary);
        if (count == 0) {
            return null;
        }
        List<Address> list = this.findByC_C_C_P(companyId, classNameId, classPK, primary, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Address[] findByC_C_C_P_PrevAndNext(long addressId, long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator) throws NoSuchAddressException {
        Address address = this.findByPrimaryKey(addressId);
        Session session = null;
        try {
            session = this.openSession();
            Address[] array = new AddressImpl[]{this.getByC_C_C_P_PrevAndNext(session, address, companyId, classNameId, classPK, primary, orderByComparator, true), address, this.getByC_C_C_P_PrevAndNext(session, address, companyId, classNameId, classPK, primary, orderByComparator, false)};
            Address[] addressArray = array;
            return addressArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address getByC_C_C_P_PrevAndNext(Session session, Address address, long companyId, long classNameId, long classPK, boolean primary, OrderByComparator<Address> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_ADDRESS_WHERE);
        query.append("address.companyId = ? AND ");
        query.append("address.classNameId = ? AND ");
        query.append("address.classPK = ? AND ");
        query.append(_FINDER_COLUMN_C_C_C_P_PRIMARY_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY address.createDate ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(companyId);
        qPos.add(classNameId);
        qPos.add(classPK);
        qPos.add(primary);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)address)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Address)list.get(1);
        }
        return null;
    }

    public void removeByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary) {
        for (Address address : this.findByC_C_C_P(companyId, classNameId, classPK, primary, -1, -1, null)) {
            this.remove((BaseModel)address);
        }
    }

    public int countByC_C_C_P(long companyId, long classNameId, long classPK, boolean primary) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_C_C_P;
        Object[] finderArgs = new Object[]{companyId, classNameId, classPK, primary};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_ADDRESS_WHERE);
            query.append("address.companyId = ? AND ");
            query.append("address.classNameId = ? AND ");
            query.append("address.classPK = ? AND ");
            query.append(_FINDER_COLUMN_C_C_C_P_PRIMARY_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                qPos.add(classNameId);
                qPos.add(classPK);
                qPos.add(primary);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AddressPersistenceImpl() {
        this.setModelClass(Address.class);
    }

    public void cacheResult(Address address) {
        this.entityCache.putResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, (Serializable)Long.valueOf(address.getPrimaryKey()), (Serializable)address);
        address.resetOriginalValues();
    }

    public void cacheResult(List<Address> addresses) {
        for (Address address : addresses) {
            if (this.entityCache.getResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, (Serializable)Long.valueOf(address.getPrimaryKey())) == null) {
                this.cacheResult(address);
                continue;
            }
            address.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AddressImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Address address) {
        this.entityCache.removeResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, (Serializable)Long.valueOf(address.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<Address> addresses) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Address address : addresses) {
            this.entityCache.removeResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, (Serializable)Long.valueOf(address.getPrimaryKey()));
        }
    }

    public Address create(long addressId) {
        AddressImpl address = new AddressImpl();
        address.setNew(true);
        address.setPrimaryKey(addressId);
        String uuid = PortalUUIDUtil.generate();
        address.setUuid(uuid);
        address.setCompanyId(this.companyProvider.getCompanyId());
        return address;
    }

    public Address remove(long addressId) throws NoSuchAddressException {
        return this.remove(Long.valueOf(addressId));
    }

    public Address remove(Serializable primaryKey) throws NoSuchAddressException {
        Session session = null;
        try {
            session = this.openSession();
            Address address = (Address)session.get(AddressImpl.class, primaryKey);
            if (address == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAddressException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Address address2 = (Address)this.remove((BaseModel)address);
            return address2;
        }
        catch (NoSuchAddressException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Address removeImpl(Address address) {
        address = this.toUnwrappedModel(address);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)address)) {
                address = (Address)session.get(AddressImpl.class, address.getPrimaryKeyObj());
            }
            if (address != null) {
                session.delete((Object)address);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (address != null) {
            this.clearCache(address);
        }
        return address;
    }

    public Address updateImpl(Address address) {
        address = this.toUnwrappedModel(address);
        boolean isNew = address.isNew();
        AddressModelImpl addressModelImpl = (AddressModelImpl)address;
        if (Validator.isNull((String)address.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            address.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && address.getCreateDate() == null) {
            if (serviceContext == null) {
                address.setCreateDate(now);
            } else {
                address.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!addressModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                address.setModifiedDate(now);
            } else {
                address.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (address.isNew()) {
                session.save((Object)address);
                address.setNew(false);
            } else {
                address = (Address)session.merge((Object)address);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !AddressModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else {
            Object[] args;
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
                args = new Object[]{addressModelImpl.getUuid()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalUuid(), addressModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
                args = new Object[]{addressModelImpl.getUuid(), addressModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_UUID_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_UUID_C, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
                args = new Object[]{addressModelImpl.getCompanyId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMPANYID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMPANYID, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_USERID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID, args);
                args = new Object[]{addressModelImpl.getUserId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_USERID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_USERID, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId(), addressModelImpl.getOriginalClassPK()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C_C, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_M.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId(), addressModelImpl.getOriginalClassPK(), addressModelImpl.getOriginalMailing()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C_C_M, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_M, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK(), addressModelImpl.getMailing()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C_C_M, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_M, args);
            }
            if ((addressModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_P.getColumnBitmask()) != 0L) {
                args = new Object[]{addressModelImpl.getOriginalCompanyId(), addressModelImpl.getOriginalClassNameId(), addressModelImpl.getOriginalClassPK(), addressModelImpl.getOriginalPrimary()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C_C_P, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_P, args);
                args = new Object[]{addressModelImpl.getCompanyId(), addressModelImpl.getClassNameId(), addressModelImpl.getClassPK(), addressModelImpl.getPrimary()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C_C_P, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_C_C_C_P, args);
            }
        }
        this.entityCache.putResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, (Serializable)Long.valueOf(address.getPrimaryKey()), (Serializable)address, false);
        address.resetOriginalValues();
        return address;
    }

    protected Address toUnwrappedModel(Address address) {
        if (address instanceof AddressImpl) {
            return address;
        }
        AddressImpl addressImpl = new AddressImpl();
        addressImpl.setNew(address.isNew());
        addressImpl.setPrimaryKey(address.getPrimaryKey());
        addressImpl.setMvccVersion(address.getMvccVersion());
        addressImpl.setUuid(address.getUuid());
        addressImpl.setAddressId(address.getAddressId());
        addressImpl.setCompanyId(address.getCompanyId());
        addressImpl.setUserId(address.getUserId());
        addressImpl.setUserName(address.getUserName());
        addressImpl.setCreateDate(address.getCreateDate());
        addressImpl.setModifiedDate(address.getModifiedDate());
        addressImpl.setClassNameId(address.getClassNameId());
        addressImpl.setClassPK(address.getClassPK());
        addressImpl.setStreet1(address.getStreet1());
        addressImpl.setStreet2(address.getStreet2());
        addressImpl.setStreet3(address.getStreet3());
        addressImpl.setCity(address.getCity());
        addressImpl.setZip(address.getZip());
        addressImpl.setRegionId(address.getRegionId());
        addressImpl.setCountryId(address.getCountryId());
        addressImpl.setTypeId(address.getTypeId());
        addressImpl.setMailing(address.isMailing());
        addressImpl.setPrimary(address.isPrimary());
        return addressImpl;
    }

    public Address findByPrimaryKey(Serializable primaryKey) throws NoSuchAddressException {
        Address address = this.fetchByPrimaryKey(primaryKey);
        if (address == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAddressException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return address;
    }

    public Address findByPrimaryKey(long addressId) throws NoSuchAddressException {
        return this.findByPrimaryKey(Long.valueOf(addressId));
    }

    public Address fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Address address = (Address)serializable;
        if (address == null) {
            Session session = null;
            try {
                session = this.openSession();
                address = (Address)session.get(AddressImpl.class, primaryKey);
                if (address != null) {
                    this.cacheResult(address);
                } else {
                    this.entityCache.putResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return address;
    }

    public Address fetchByPrimaryKey(long addressId) {
        return this.fetchByPrimaryKey(Long.valueOf(addressId));
    }

    public Map<Serializable, Address> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Address> map = new HashMap<Serializable, Address>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Address address = this.fetchByPrimaryKey(primaryKey);
            if (address != null) {
                map.put(primaryKey, address);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Address)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_ADDRESS_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(String.valueOf(serializable));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Address address : q.list()) {
                map.put(address.getPrimaryKeyObj(), address);
                this.cacheResult(address);
                uncachedPrimaryKeys.remove(address.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(AddressModelImpl.ENTITY_CACHE_ENABLED, AddressImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Address> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Address> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Address> findAll(int start, int end, OrderByComparator<Address> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Address> findAll(int start, int end, OrderByComparator<Address> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ADDRESS);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ADDRESS;
                if (pagination) {
                    sql = sql.concat(" ORDER BY address.createDate ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Address address : this.findAll()) {
            this.remove((BaseModel)address);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ADDRESS);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AddressModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(AddressImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

