/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.cache;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.filters.CacheResponseData;
import com.liferay.util.servlet.filters.CacheResponseUtil;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CacheFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = CacheFilter.class + "SKIP_FILTER";
    private static final int _PATTERN_FRIENDLY = 0;
    private static final int _PATTERN_LAYOUT = 1;
    private static final int _PATTERN_RESOURCE = 2;
    private static final Log _log = LogFactoryUtil.getLog(CacheFilter.class);
    private int _pattern;

    public void init(FilterConfig filterConfig) {
        super.init(filterConfig);
        this._pattern = GetterUtil.getInteger((String)filterConfig.getInitParameter("pattern"));
        if (this._pattern != 0 && this._pattern != 1 && this._pattern != 2) {
            _log.error((Object)"Cache pattern is invalid");
        }
    }

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return this.isCacheableRequest(request) && !this.isInclude(request) && !this.isAlreadyFiltered(request);
    }

    protected String getCacheKey(HttpServletRequest request) {
        int pos;
        StringBundler sb = new StringBundler(13);
        sb.append(HttpUtil.getProtocol((HttpServletRequest)request));
        sb.append("://");
        String url = PortalUtil.getCurrentCompleteURL((HttpServletRequest)request);
        sb.append(HttpUtil.getDomain((String)url));
        sb.append(request.getContextPath());
        sb.append(request.getServletPath());
        sb.append(request.getPathInfo());
        sb.append("?");
        String queryString = request.getQueryString();
        if (queryString == null && (queryString = (String)request.getAttribute("javax.servlet.forward.query_string")) == null && (pos = url.indexOf(63)) > -1) {
            queryString = url.substring(pos + 1);
        }
        if (queryString != null) {
            sb.append(queryString);
        }
        sb.append("#");
        String languageId = (String)request.getAttribute("I18N_LANGUAGE_ID");
        if (Validator.isNull((String)languageId)) {
            languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        }
        sb.append(languageId);
        String userAgent = GetterUtil.getString((String)request.getHeader("User-Agent"));
        sb.append("#");
        sb.append(StringUtil.toLowerCase((String)userAgent).hashCode());
        sb.append("#");
        sb.append(BrowserSnifferUtil.acceptsGzip((HttpServletRequest)request));
        return StringUtil.toUpperCase((String)sb.toString().trim());
    }

    protected long getPlid(long companyId, String pathInfo, String servletPath, long defaultPlid) {
        if (this._pattern == 1) {
            return defaultPlid;
        }
        if (Validator.isNull((String)pathInfo) || !pathInfo.startsWith("/")) {
            return 0L;
        }
        String friendlyURL = null;
        int pos = pathInfo.indexOf(47, 1);
        if (pos != -1) {
            friendlyURL = pathInfo.substring(0, pos);
        } else if (pathInfo.length() > 1) {
            friendlyURL = pathInfo;
        }
        if (Validator.isNull((String)friendlyURL)) {
            return 0L;
        }
        long groupId = 0L;
        boolean privateLayout = false;
        try {
            Group group = GroupLocalServiceUtil.getFriendlyURLGroup((long)companyId, (String)friendlyURL);
            groupId = group.getGroupId();
            if (servletPath.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING) || servletPath.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING)) {
                privateLayout = true;
            } else if (servletPath.startsWith(PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING)) {
                privateLayout = false;
            }
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)nsle);
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)e);
            }
            return 0L;
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != pathInfo.length()) {
            friendlyURL = pathInfo.substring(pos);
        }
        if (Validator.isNull((String)friendlyURL)) {
            try {
                long plid = LayoutLocalServiceUtil.getDefaultPlid((long)groupId, (boolean)privateLayout);
                return plid;
            }
            catch (Exception e) {
                _log.warn((Throwable)e);
                return 0L;
            }
        }
        if (friendlyURL.endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout((long)groupId, (boolean)privateLayout, (String)friendlyURL);
            return layout.getPlid();
        }
        catch (NoSuchLayoutException nsle) {
            _log.warn((Throwable)nsle);
            return 0L;
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return 0L;
        }
    }

    protected boolean isAlreadyFiltered(HttpServletRequest request) {
        return request.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isCacheableData(long companyId, HttpServletRequest request) {
        try {
            if (this._pattern == 2) {
                return true;
            }
            long plid = this.getPlid(companyId, request.getPathInfo(), request.getServletPath(), ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id"));
            if (plid <= 0L) {
                return false;
            }
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layout.isTypePortlet()) {
                return false;
            }
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            return layoutTypePortlet.isCacheable();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isCacheableRequest(HttpServletRequest request) {
        String plid;
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNotNull((String)portletId)) {
            return false;
        }
        if (this._pattern == 0 || this._pattern == 1) {
            long userId = PortalUtil.getUserId((HttpServletRequest)request);
            String remoteUser = request.getRemoteUser();
            if (userId > 0L || Validator.isNotNull((String)remoteUser)) {
                return false;
            }
        }
        return this._pattern != 1 || !Validator.isNull((String)(plid = ParamUtil.getString((HttpServletRequest)request, (String)"p_l_id")));
    }

    protected boolean isCacheableResponse(BufferCacheServletResponse bufferCacheServletResponse) {
        return bufferCacheServletResponse.getStatus() == 200 && bufferCacheServletResponse.getBufferSize() < PropsValues.CACHE_CONTENT_THRESHOLD_SIZE;
    }

    protected boolean isInclude(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        return uri != null;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        long companyId;
        CacheResponseData cacheResponseData;
        request.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        String key = this.getCacheKey(request);
        String pAuth = request.getParameter("p_auth");
        if (Validator.isNotNull((String)pAuth)) {
            try {
                AuthTokenUtil.checkCSRFToken((HttpServletRequest)request, (String)CacheFilter.class.getName());
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Request is not cacheable " + key + ", invalid token received"));
                }
                this.processFilter(CacheFilter.class.getName(), request, response, filterChain);
                return;
            }
            key = key.replace(StringUtil.toUpperCase((String)pAuth), "VALID");
        }
        if ((cacheResponseData = CacheUtil.getCacheResponseData(companyId = PortalInstances.getCompanyId(request), key)) == null || !cacheResponseData.isValid()) {
            if (!this._isValidCache(cacheResponseData) || !this.isCacheableData(companyId, request)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Request is not cacheable " + key));
                }
                if (cacheResponseData == null) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Caching request with invalid state " + key));
                    }
                    CacheUtil.putCacheResponseData(companyId, key, new CacheResponseData());
                }
                this.processFilter(CacheFilter.class.getName(), request, response, filterChain);
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Caching request " + key));
            }
            BufferCacheServletResponse bufferCacheServletResponse = new BufferCacheServletResponse(response);
            this.processFilter(CacheFilter.class.getName(), request, (HttpServletResponse)bufferCacheServletResponse, filterChain);
            cacheResponseData = new CacheResponseData(bufferCacheServletResponse);
            LastPath lastPath = (LastPath)request.getAttribute("LAST_PATH");
            if (lastPath != null) {
                cacheResponseData.setAttribute("LAST_PATH", (Object)lastPath);
            }
            String cacheControl = GetterUtil.getString((String)bufferCacheServletResponse.getHeader("Cache-Control"));
            if (this.isCacheableResponse(bufferCacheServletResponse) && !cacheControl.contains("no-cache") && this.isCacheableRequest(request)) {
                CacheUtil.putCacheResponseData(companyId, key, cacheResponseData);
            }
        } else {
            LastPath lastPath = (LastPath)cacheResponseData.getAttribute("LAST_PATH");
            if (lastPath != null) {
                HttpSession session = request.getSession();
                session.setAttribute("LAST_PATH", (Object)lastPath);
            }
        }
        CacheResponseUtil.write((HttpServletResponse)response, (CacheResponseData)cacheResponseData);
    }

    private boolean _isValidCache(CacheResponseData cacheResponseData) {
        return cacheResponseData == null || cacheResponseData.isValid();
    }
}

