/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.blogs.kernel.model.BlogsEntry;
import com.liferay.blogs.kernel.service.BlogsEntryLocalServiceUtil;
import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.blogs.linkback.LinkbackConsumerUtil;
import java.util.List;

public class VerifyBlogsTrackbacks
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyBlogsTrackbacks.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyMBDiscussions();
    }

    protected void verifyMBDiscussions() {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List mbDiscussions = MBMessageLocalServiceUtil.getDiscussions((String)BlogsEntry.class.getName());
            for (MBDiscussion mbDiscussion : mbDiscussions) {
                try {
                    BlogsEntry entry = BlogsEntryLocalServiceUtil.getBlogsEntry((long)mbDiscussion.getClassPK());
                    List mbMessages = MBMessageLocalServiceUtil.getThreadMessages((long)mbDiscussion.getThreadId(), (int)0);
                    for (MBMessage mbMessage : mbMessages) {
                        this._verifyPost(entry, mbMessage);
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    private void _verifyPost(BlogsEntry entry, MBMessage mbMessage) throws PortalException {
        int end;
        String entryURL = "/-/blogs/" + entry.getUrlTitle();
        String body = mbMessage.getBody();
        String url = null;
        int start = body.indexOf("[url=");
        if (start > -1 && (end = body.indexOf("]", start += "[url=".length())) > -1) {
            url = body.substring(start, end);
        }
        if (Validator.isNotNull(url)) {
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)mbMessage.getCompanyId());
            if (mbMessage.getUserId() == defaultUserId) {
                LinkbackConsumerUtil.verifyTrackback(mbMessage.getMessageId(), url, entryURL);
            }
        }
    }
}

