/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryServiceBaseImpl;
import com.liferay.portlet.announcements.service.permission.AnnouncementsEntryPermission;

public class AnnouncementsEntryServiceImpl
extends AnnouncementsEntryServiceBaseImpl {
    public AnnouncementsEntry addEntry(long plid, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException {
        String portletId;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (alert) {
            portletId = PortletProviderUtil.getPortletId((String)"com.liferay.announcements.kernel.model.AlertsEntry", (PortletProvider.Action)PortletProvider.Action.MANAGE);
            AnnouncementsEntryPermission.check(permissionChecker, plid, portletId, "ADD_ENTRY");
        } else {
            portletId = PortletProviderUtil.getPortletId((String)AnnouncementsEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
            AnnouncementsEntryPermission.check(permissionChecker, plid, portletId, "ADD_ENTRY");
        }
        if (classNameId == 0L) {
            if (!PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_GENERAL_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{"90", "90", "ADD_GENERAL_ANNOUNCEMENTS"});
            }
        } else {
            String className = PortalUtil.getClassName((long)classNameId);
            if (className.equals(Group.class.getName()) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{"MANAGE_ANNOUNCEMENTS"});
            }
            if (className.equals(Organization.class.getName()) && !OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{"MANAGE_ANNOUNCEMENTS"});
            }
            if (className.equals(Role.class.getName())) {
                Role role = this.roleLocalService.getRole(classPK);
                if (role.isTeam()) {
                    Team team = this.teamLocalService.getTeam(role.getClassPK());
                    if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)team.getGroupId(), (String)"MANAGE_ANNOUNCEMENTS") || !RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)team.getGroupId(), (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), classPK, new String[]{"MANAGE_ANNOUNCEMENTS"});
                    }
                } else if (!RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                    throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{"MANAGE_ANNOUNCEMENTS"});
                }
            }
            if (className.equals(UserGroup.class.getName()) && !UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, new String[]{"MANAGE_ANNOUNCEMENTS"});
            }
        }
        return this.announcementsEntryLocalService.addEntry(this.getUserId(), classNameId, classPK, title, content, url, type, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, displayImmediately, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, priority, alert);
    }

    public void deleteEntry(long entryId) throws PortalException {
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.announcementsEntryLocalService.deleteEntry(entryId);
    }

    public AnnouncementsEntry getEntry(long entryId) throws PortalException {
        AnnouncementsEntry entry = this.announcementsEntryLocalService.getEntry(entryId);
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entry, "VIEW");
        return entry;
    }

    public AnnouncementsEntry updateEntry(long entryId, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority) throws PortalException {
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.announcementsEntryLocalService.updateEntry(this.getUserId(), entryId, title, content, url, type, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, displayImmediately, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, priority);
    }
}

