/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.linkback;

import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portlet.blogs.linkback.LinkbackConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LinkbackConsumerImpl
implements LinkbackConsumer {
    private static final Log _log = LogFactoryUtil.getLog(LinkbackConsumerImpl.class);
    private final List<Tuple> _trackbacks = Collections.synchronizedList(new ArrayList());

    @Override
    public void addNewTrackback(long commentId, String url, String entryURL) {
        this._trackbacks.add(new Tuple(new Object[]{commentId, url, entryURL}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verifyNewTrackbacks() {
        Tuple tuple = null;
        while (!this._trackbacks.isEmpty()) {
            List<Tuple> list = this._trackbacks;
            synchronized (list) {
                tuple = this._trackbacks.remove(0);
            }
            long commentId = (Long)tuple.getObject(0);
            String url = (String)tuple.getObject(1);
            String entryUrl = (String)tuple.getObject(2);
            this.verifyTrackback(commentId, url, entryUrl);
        }
    }

    @Override
    public void verifyTrackback(long commentId, String url, String entryURL) {
        try {
            String result = HttpUtil.URLtoString((String)url);
            if (result.contains(entryURL)) {
                return;
            }
        }
        catch (Exception result) {
            // empty catch block
        }
        try {
            CommentManagerUtil.deleteComment((long)commentId);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to delete trackback comment " + commentId), (Throwable)e);
        }
    }
}

