/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerUtil;
import com.liferay.document.library.kernel.exception.DirectoryNameException;
import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.store.StoreFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DLStoreImpl
implements DLStore {
    @BeanReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    private final StoreFactory _storeFactory = StoreFactory.getInstance();

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName) || dirName.equals("/")) {
            throw new DirectoryNameException(dirName);
        }
        Store store = this._storeFactory.getStore();
        store.addDirectory(companyId, repositoryId, dirName);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((byte[])bytes);
        }
        Store store = this._storeFactory.getStore();
        store.addFile(companyId, repositoryId, fileName, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        Store store = this._storeFactory.getStore();
        store.addFile(companyId, repositoryId, fileName, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, boolean validateFileExtension, InputStream is) throws PortalException {
        if (is instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)is;
            File file = byteArrayFileInputStream.getFile();
            this.addFile(companyId, repositoryId, fileName, validateFileExtension, file);
            return;
        }
        this.validate(fileName, validateFileExtension);
        Store store = this._storeFactory.getStore();
        if (!PropsValues.DL_STORE_ANTIVIRUS_ENABLED || !AntivirusScannerUtil.isActive()) {
            store.addFile(companyId, repositoryId, fileName, is);
        } else {
            File tempFile = null;
            try {
                if (is.markSupported()) {
                    is.mark(is.available() + 1);
                    AntivirusScannerUtil.scan((InputStream)is);
                    is.reset();
                    store.addFile(companyId, repositoryId, fileName, is);
                } else {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)is);
                    AntivirusScannerUtil.scan((File)tempFile);
                    store.addFile(companyId, repositoryId, fileName, tempFile);
                }
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to scan file " + fileName, (Throwable)ioe);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    public void addFile(long companyId, long repositoryId, String fileName, byte[] bytes) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, bytes);
    }

    public void addFile(long companyId, long repositoryId, String fileName, File file) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, file);
    }

    public void addFile(long companyId, long repositoryId, String fileName, InputStream is) throws PortalException {
        this.addFile(companyId, repositoryId, fileName, true, is);
    }

    public void checkRoot(long companyId) {
        Store store = this._storeFactory.getStore();
        store.checkRoot(companyId);
    }

    public void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        Store store = this._storeFactory.getStore();
        store.copyFileVersion(companyId, repositoryId, fileName, fromVersionLabel, toVersionLabel);
    }

    public void deleteDirectory(long companyId, long repositoryId, String dirName) {
        Store store = this._storeFactory.getStore();
        store.deleteDirectory(companyId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        store.deleteFile(companyId, repositoryId, fileName);
    }

    public void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        store.deleteFile(companyId, repositoryId, fileName, versionLabel);
    }

    public File getFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.getFile(companyId, repositoryId, fileName);
    }

    public File getFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        return store.getFile(companyId, repositoryId, fileName, versionLabel);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.getFileAsBytes(companyId, repositoryId, fileName);
    }

    public byte[] getFileAsBytes(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        return store.getFileAsBytes(companyId, repositoryId, fileName, versionLabel);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.getFileAsStream(companyId, repositoryId, fileName);
    }

    public InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        return store.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        Store store = this._storeFactory.getStore();
        return store.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.getFileSize(companyId, repositoryId, fileName);
    }

    public boolean hasDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)dirName)) {
            throw new DirectoryNameException(dirName);
        }
        Store store = this._storeFactory.getStore();
        return store.hasDirectory(companyId, repositoryId, dirName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName) throws PortalException {
        this.validate(fileName, false);
        Store store = this._storeFactory.getStore();
        return store.hasFile(companyId, repositoryId, fileName);
    }

    public boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        this.validate(fileName, false, versionLabel);
        Store store = this._storeFactory.getStore();
        return store.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    @Deprecated
    public boolean isValidName(String name) {
        return DLValidatorUtil.isValidName((String)name);
    }

    public void move(String srcDir, String destDir) {
        Store store = this._storeFactory.getStore();
        store.move(srcDir, destDir);
    }

    public void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        Store store = this._storeFactory.getStore();
        store.updateFile(companyId, repositoryId, newRepositoryId, fileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String newFileName) throws PortalException {
        Store store = this._storeFactory.getStore();
        store.updateFile(companyId, repositoryId, fileName, newFileName);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
        if (PropsValues.DL_STORE_ANTIVIRUS_ENABLED) {
            AntivirusScannerUtil.scan((File)file);
        }
        Store store = this._storeFactory.getStore();
        store.updateFile(companyId, repositoryId, fileName, versionLabel, file);
    }

    public void updateFile(long companyId, long repositoryId, String fileName, String fileExtension, boolean validateFileExtension, String versionLabel, String sourceFileName, InputStream is) throws PortalException {
        if (is instanceof ByteArrayFileInputStream) {
            ByteArrayFileInputStream byteArrayFileInputStream = (ByteArrayFileInputStream)is;
            File file = byteArrayFileInputStream.getFile();
            this.updateFile(companyId, repositoryId, fileName, fileExtension, validateFileExtension, versionLabel, sourceFileName, file);
            return;
        }
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
        Store store = this._storeFactory.getStore();
        if (!PropsValues.DL_STORE_ANTIVIRUS_ENABLED || !AntivirusScannerUtil.isActive()) {
            store.updateFile(companyId, repositoryId, fileName, versionLabel, is);
        } else {
            File tempFile = null;
            try {
                if (is.markSupported()) {
                    is.mark(is.available() + 1);
                    AntivirusScannerUtil.scan((InputStream)is);
                    is.reset();
                    store.updateFile(companyId, repositoryId, fileName, versionLabel, is);
                } else {
                    tempFile = FileUtil.createTempFile();
                    FileUtil.write((File)tempFile, (InputStream)is);
                    AntivirusScannerUtil.scan((File)tempFile);
                    store.updateFile(companyId, repositoryId, fileName, versionLabel, tempFile);
                }
            }
            catch (IOException ioe) {
                throw new SystemException("Unable to scan file " + fileName, (Throwable)ioe);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    public void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        Store store = this._storeFactory.getStore();
        store.updateFileVersion(companyId, repositoryId, fileName, fromVersionLabel, toVersionLabel);
    }

    public void validate(String fileName, boolean validateFileExtension) throws PortalException {
        DLValidatorUtil.validateFileName((String)fileName);
        if (validateFileExtension) {
            DLValidatorUtil.validateFileExtension((String)fileName);
        }
    }

    public void validate(String fileName, boolean validateFileExtension, byte[] bytes) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (byte[])bytes);
    }

    public void validate(String fileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (File)file);
    }

    public void validate(String fileName, boolean validateFileExtension, InputStream is) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (InputStream)is);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateSourceFileExtension((String)fileExtension, (String)sourceFileName);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (File)file);
    }

    public void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream is) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension);
        DLValidatorUtil.validateFileSize((String)fileName, (InputStream)is);
    }

    @Deprecated
    public void validateDirectoryName(String directoryName) throws PortalException {
        DLValidatorUtil.validateDirectoryName((String)directoryName);
    }

    protected void validate(String fileName, boolean validateFileExtension, String versionLabel) throws PortalException {
        this.validate(fileName, validateFileExtension);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, File file, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, file);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }

    protected void validate(String fileName, String fileExtension, String sourceFileName, boolean validateFileExtension, InputStream is, String versionLabel) throws PortalException {
        this.validate(fileName, fileExtension, sourceFileName, validateFileExtension, is);
        DLValidatorUtil.validateVersionLabel((String)versionLabel);
    }
}

