/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.util;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsValues;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LayoutsTreeUtil {
    private static final Log _log = LogFactoryUtil.getLog(LayoutsTreeUtil.class);

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, String treeId) throws Exception {
        return LayoutsTreeUtil.getLayoutsJSON(request, groupId, privateLayout, parentLayoutId, null, incomplete, treeId);
    }

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long layoutId, int max) throws Exception {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        long parentLayoutId = layout.getParentLayoutId();
        long includedLayoutIndex = LayoutServiceUtil.getLayoutsCount((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (int)layout.getPriority());
        int total = LayoutServiceUtil.getLayoutsCount((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
        int start = (int)includedLayoutIndex - 1;
        int end = (int)includedLayoutIndex + max;
        if (end > total) {
            start = total - max;
            end = total;
            if (start < 0) {
                start = 0;
            }
        }
        List layouts = LayoutServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (boolean)true, (int)start, (int)end);
        JSONObject jsonObject = LayoutsTreeUtil._toJSONObject(request, groupId, layouts, total);
        List ancestorLayouts = LayoutServiceUtil.getAncestorLayouts((long)layout.getPlid());
        long[] ancestorLayoutIds = new long[ancestorLayouts.size()];
        String[] ancestorLayoutNames = new String[ancestorLayouts.size()];
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        for (int i = 0; i < ancestorLayouts.size(); ++i) {
            Layout ancestorLayout = (Layout)ancestorLayouts.get(i);
            ancestorLayoutIds[i] = ancestorLayout.getLayoutId();
            ancestorLayoutNames[i] = ancestorLayout.getName(locale);
        }
        jsonObject.put("ancestorLayoutIds", (Object)ancestorLayoutIds);
        jsonObject.put("ancestorLayoutNames", (Object)ancestorLayoutNames);
        jsonObject.put("start", start);
        return jsonObject.toString();
    }

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, long[] expandedLayoutIds, boolean incomplete, String treeId) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(13);
            sb.append("getLayoutsJSON(groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", parentLayoutId=");
            sb.append(parentLayoutId);
            sb.append(", expandedLayoutIds=");
            sb.append((Object)expandedLayoutIds);
            sb.append(", incomplete=");
            sb.append(incomplete);
            sb.append(", treeId=");
            sb.append(treeId);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        LayoutTreeNodes layoutTreeNodes = LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, privateLayout, parentLayoutId, incomplete, expandedLayoutIds, treeId);
        return LayoutsTreeUtil._toJSON(request, groupId, layoutTreeNodes);
    }

    public static String getLayoutsJSON(HttpServletRequest request, long groupId, String treeId) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("getLayoutsJSON(groupId=");
            sb.append(groupId);
            sb.append(", treeId=");
            sb.append(treeId);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes();
        layoutTreeNodes.addAll(LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, true, 0L, false, null, treeId));
        layoutTreeNodes.addAll(LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, false, 0L, false, null, treeId));
        return LayoutsTreeUtil._toJSON(request, groupId, layoutTreeNodes);
    }

    private static Layout _fetchCurrentLayout(HttpServletRequest request) {
        long selPlid = ParamUtil.getLong((HttpServletRequest)request, (String)"selPlid");
        if (selPlid > 0L) {
            return LayoutLocalServiceUtil.fetchLayout((long)selPlid);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        return null;
    }

    private static List<Layout> _getAncestorLayouts(HttpServletRequest request) throws Exception {
        Layout layout = LayoutsTreeUtil._fetchCurrentLayout(request);
        if (layout == null) {
            return Collections.emptyList();
        }
        List ancestorLayouts = LayoutServiceUtil.getAncestorLayouts((long)layout.getPlid());
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("_getAncestorLayouts(plid=");
            sb.append(layout.getPlid());
            sb.append(", ancestorLayouts=");
            sb.append((Object)ancestorLayouts);
            sb.append(", layout=");
            sb.append((Object)layout);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        ancestorLayouts.add(layout);
        return ancestorLayouts;
    }

    private static LayoutTreeNodes _getLayoutTreeNodes(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, long[] expandedLayoutIds, String treeId) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(13);
            sb.append("_getLayoutTreeNodes(groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", parentLayoutId=");
            sb.append(parentLayoutId);
            sb.append(", expandedLayoutIds=");
            sb.append((Object)expandedLayoutIds);
            sb.append(", incomplete=");
            sb.append(incomplete);
            sb.append(", treeId=");
            sb.append(treeId);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        ArrayList<LayoutTreeNode> layoutTreeNodes = new ArrayList<LayoutTreeNode>();
        List<Layout> ancestorLayouts = LayoutsTreeUtil._getAncestorLayouts(request);
        List layouts = LayoutServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId, (boolean)incomplete, (int)-1, (int)-1);
        for (Layout layout : LayoutsTreeUtil._paginateLayouts(request, groupId, privateLayout, parentLayoutId, layouts, treeId)) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            LayoutTreeNodes childLayoutTreeNodes = null;
            if (LayoutsTreeUtil._isExpandableLayout(request, ancestorLayouts, expandedLayoutIds, layout)) {
                if (layout instanceof VirtualLayout) {
                    VirtualLayout virtualLayout = (VirtualLayout)layout;
                    childLayoutTreeNodes = LayoutsTreeUtil._getLayoutTreeNodes(request, virtualLayout.getSourceGroupId(), virtualLayout.isPrivateLayout(), virtualLayout.getLayoutId(), incomplete, expandedLayoutIds, treeId);
                } else {
                    childLayoutTreeNodes = LayoutsTreeUtil._getLayoutTreeNodes(request, groupId, layout.isPrivateLayout(), layout.getLayoutId(), incomplete, expandedLayoutIds, treeId);
                }
            } else {
                int childLayoutsCount = LayoutServiceUtil.getLayoutsCount((long)groupId, (boolean)privateLayout, (long)layout.getLayoutId());
                childLayoutTreeNodes = new LayoutTreeNodes(new ArrayList<LayoutTreeNode>(), childLayoutsCount);
            }
            layoutTreeNode.setChildLayoutTreeNodes(childLayoutTreeNodes);
            layoutTreeNodes.add(layoutTreeNode);
        }
        return new LayoutTreeNodes(layoutTreeNodes, layouts.size());
    }

    private static int _getLoadedLayoutsCount(HttpSession session, long groupId, boolean privateLayout, long layoutId, String treeId) throws Exception {
        StringBundler sb = new StringBundler(7);
        sb.append(treeId);
        sb.append(":");
        sb.append(groupId);
        sb.append(":");
        sb.append(privateLayout);
        sb.append(":");
        sb.append("Pagination");
        String key = sb.toString();
        String paginationJSON = SessionClicks.get((HttpSession)session, (String)key, (String)JSONFactoryUtil.getNullJSON());
        JSONObject paginationJSONObject = JSONFactoryUtil.createJSONObject((String)paginationJSON);
        if (_log.isDebugEnabled()) {
            sb = new StringBundler(9);
            sb.append("_getLoadedLayoutsCount(key=");
            sb.append(key);
            sb.append(", layoutId=");
            sb.append(layoutId);
            sb.append(", paginationJSON=");
            sb.append(paginationJSON);
            sb.append(", paginationJSONObject");
            sb.append((Object)paginationJSONObject);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        return paginationJSONObject.getInt(String.valueOf(layoutId), 0);
    }

    private static boolean _isDeleteable(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"DELETE")) {
            return false;
        }
        Group group = layout.getGroup();
        return !group.isGuest() || layout.isPrivateLayout() || !layout.isRootLayout() || LayoutLocalServiceUtil.getLayoutsCount((Group)group, (boolean)false, (long)0L) != 1;
    }

    private static boolean _isExpandableLayout(HttpServletRequest request, List<Layout> ancestorLayouts, long[] expandedLayoutIds, Layout layout) {
        boolean expandParentLayouts = ParamUtil.getBoolean((HttpServletRequest)request, (String)"expandParentLayouts");
        return expandParentLayouts || ancestorLayouts.contains(layout) || ArrayUtil.contains((long[])expandedLayoutIds, (long)layout.getLayoutId());
    }

    private static boolean _isPaginationEnabled(HttpServletRequest request) {
        boolean paginate = ParamUtil.getBoolean((HttpServletRequest)request, (String)"paginate", (boolean)true);
        return paginate && PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN > -1;
    }

    private static List<Layout> _paginateLayouts(HttpServletRequest request, long groupId, boolean privateLayout, long parentLayoutId, List<Layout> layouts, String treeId) throws Exception {
        if (!LayoutsTreeUtil._isPaginationEnabled(request)) {
            return layouts;
        }
        HttpSession session = request.getSession();
        int loadedLayoutsCount = LayoutsTreeUtil._getLoadedLayoutsCount(session, groupId, privateLayout, parentLayoutId, treeId);
        int start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start");
        int end = ParamUtil.getInteger((HttpServletRequest)request, (String)"end", (int)((start = Math.max(0, Math.min(start, layouts.size()))) + PropsValues.LAYOUT_MANAGE_PAGES_INITIAL_CHILDREN));
        if (loadedLayoutsCount > end) {
            end = loadedLayoutsCount;
        }
        end = Math.max(start, Math.min(end, layouts.size()));
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(7);
            sb.append("_paginateLayouts(loadedLayoutsCount=");
            sb.append(loadedLayoutsCount);
            sb.append(", start=");
            sb.append(start);
            sb.append(", end=");
            sb.append(end);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        return layouts.subList(start, end);
    }

    private static String _toJSON(HttpServletRequest request, long groupId, LayoutTreeNodes layoutTreeNodes) throws Exception {
        JSONObject jsonObject = LayoutsTreeUtil._toJSONObject(request, groupId, layoutTreeNodes);
        return jsonObject.toString();
    }

    private static JSONObject _toJSONObject(HttpServletRequest request, long groupId, LayoutTreeNodes layoutTreeNodes) throws Exception {
        if (_log.isDebugEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("_toJSON(groupId=");
            sb.append(groupId);
            sb.append(", layoutTreeNodes=");
            sb.append((Object)layoutTreeNodes);
            sb.append(")");
            _log.debug((Object)sb.toString());
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        boolean hasManageLayoutsPermission = GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (long)groupId, (String)"MANAGE_LAYOUTS");
        for (LayoutTreeNode layoutTreeNode : layoutTreeNodes) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONObject childrenJSONObject = LayoutsTreeUtil._toJSONObject(request, groupId, layoutTreeNode.getChildLayoutTreeNodes());
            jsonObject.put("children", childrenJSONObject);
            Layout layout = layoutTreeNode.getLayout();
            jsonObject.put("contentDisplayPage", layout.isContentDisplayPage());
            jsonObject.put("deleteable", LayoutsTreeUtil._isDeleteable(layout, themeDisplay));
            jsonObject.put("friendlyURL", layout.getFriendlyURL());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                jsonObject.put("groupId", virtualLayout.getSourceGroupId());
            } else {
                jsonObject.put("groupId", layout.getGroupId());
            }
            jsonObject.put("hasChildren", layout.hasChildren());
            jsonObject.put("layoutId", layout.getLayoutId());
            jsonObject.put("name", layout.getName(themeDisplay.getLocale()));
            jsonObject.put("parentable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"ADD_LAYOUT"));
            jsonObject.put("parentLayoutId", layout.getParentLayoutId());
            jsonObject.put("plid", layout.getPlid());
            jsonObject.put("priority", layout.getPriority());
            jsonObject.put("privateLayout", layout.isPrivateLayout());
            jsonObject.put("regularURL", layout.getRegularURL(request));
            jsonObject.put("sortable", hasManageLayoutsPermission && SitesUtil.isLayoutSortable((Layout)layout));
            jsonObject.put("type", layout.getType());
            jsonObject.put("updateable", LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)"UPDATE"));
            jsonObject.put("uuid", layout.getUuid());
            LayoutRevision layoutRevision = LayoutStagingUtil.getLayoutRevision((Layout)layout);
            if (layoutRevision != null) {
                long layoutSetBranchId = layoutRevision.getLayoutSetBranchId();
                if (StagingUtil.isIncomplete((Layout)layout, (long)layoutSetBranchId)) {
                    jsonObject.put("incomplete", true);
                }
                LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
                LayoutBranch layoutBranch = layoutRevision.getLayoutBranch();
                if (!layoutBranch.isMaster()) {
                    jsonObject.put("layoutBranchId", layoutBranch.getLayoutBranchId());
                    jsonObject.put("layoutBranchName", layoutBranch.getName());
                }
                if (layoutRevision.isHead()) {
                    jsonObject.put("layoutRevisionHead", true);
                }
                jsonObject.put("layoutRevisionId", layoutRevision.getLayoutRevisionId());
                jsonObject.put("layoutSetBranchId", layoutSetBranchId);
                jsonObject.put("layoutSetBranchName", layoutSetBranch.getName());
            }
            jsonArray.put(jsonObject);
        }
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject();
        responseJSONObject.put("layouts", jsonArray);
        responseJSONObject.put("total", layoutTreeNodes.getTotal());
        return responseJSONObject;
    }

    private static JSONObject _toJSONObject(HttpServletRequest request, long groupId, List<Layout> layouts, int total) throws Exception {
        ArrayList<LayoutTreeNode> layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        for (Layout layout : layouts) {
            LayoutTreeNode layoutTreeNode = new LayoutTreeNode(layout);
            layoutTreeNodesList.add(layoutTreeNode);
        }
        LayoutTreeNodes layoutTreeNodes = new LayoutTreeNodes(layoutTreeNodesList, total);
        return LayoutsTreeUtil._toJSONObject(request, groupId, layoutTreeNodes);
    }

    private static class LayoutTreeNodes
    implements Iterable<LayoutTreeNode> {
        private final List<LayoutTreeNode> _layoutTreeNodesList;
        private int _total;

        public LayoutTreeNodes() {
            this._layoutTreeNodesList = new ArrayList<LayoutTreeNode>();
        }

        public LayoutTreeNodes(List<LayoutTreeNode> layoutTreeNodesList, int total) {
            this._layoutTreeNodesList = layoutTreeNodesList;
            this._total = total;
        }

        public void addAll(LayoutTreeNodes layoutTreeNodes) {
            this._layoutTreeNodesList.addAll(layoutTreeNodes.getLayoutTreeNodesList());
            this._total += layoutTreeNodes.getTotal();
        }

        public List<LayoutTreeNode> getLayoutTreeNodesList() {
            return this._layoutTreeNodesList;
        }

        public int getTotal() {
            return this._total;
        }

        @Override
        public Iterator<LayoutTreeNode> iterator() {
            return this._layoutTreeNodesList.iterator();
        }

        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{layoutTreeNodesList=");
            sb.append(this._layoutTreeNodesList);
            sb.append(", total=");
            sb.append(this._total);
            sb.append("}");
            return sb.toString();
        }
    }

    private static class LayoutTreeNode {
        private LayoutTreeNodes _childLayoutTreeNodes = new LayoutTreeNodes();
        private final Layout _layout;

        public LayoutTreeNode(Layout layout) {
            this._layout = layout;
        }

        public LayoutTreeNodes getChildLayoutTreeNodes() {
            return this._childLayoutTreeNodes;
        }

        public Layout getLayout() {
            return this._layout;
        }

        public void setChildLayoutTreeNodes(LayoutTreeNodes childLayoutTreeNodes) {
            this._childLayoutTreeNodes = childLayoutTreeNodes;
        }

        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{childLayoutTreeNodes=");
            sb.append((Object)this._childLayoutTreeNodes);
            sb.append(", layout=");
            sb.append((Object)this._layout);
            sb.append("}");
            return sb.toString();
        }
    }
}

