/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.util.transport.DatagramHandler;
import com.liferay.util.transport.MulticastTransport;
import java.net.DatagramPacket;
import java.net.InetAddress;

public class MulticastServerTool {
    public static void main(String[] args) {
        try {
            int port = GetterUtil.getInteger((String)args[1]);
            long interval = GetterUtil.getLong((String)args[2]);
            DatagramHandler handler = new DatagramHandler(){

                @Override
                public void process(DatagramPacket packet) {
                    String s = new String(packet.getData(), 0, packet.getLength());
                    System.out.println(s);
                }

                @Override
                public void errorReceived(Throwable t) {
                    t.printStackTrace();
                }
            };
            MulticastTransport transport = new MulticastTransport(handler, args[0], port);
            transport.connect();
            String msg = InetAddress.getLocalHost().getHostName() + ":" + port + " heartbeat ";
            int i = 0;
            while (true) {
                transport.sendMessage(msg + i);
                ++i;
                Thread.sleep(interval);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Usage: java MulticastServerTool multicastAddress port interval");
            System.exit(1);
            return;
        }
    }
}

