/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.nio.charset.CharsetEncoderUtil;
import com.liferay.portal.kernel.util.StringPool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class OutputStreamWriter
extends Writer {
    private static final int _DEFAULT_OUTPUT_BUFFER_SIZE = 8192;
    private static final CharBuffer _EMPTY_CHAR_BUFFER = CharBuffer.allocate(0);
    private final boolean _autoFlush;
    private final CharsetEncoder _charsetEncoder;
    private final String _charsetName;
    private final CharBuffer _inputCharBuffer = CharBuffer.allocate(2);
    private boolean _open = true;
    private final ByteBuffer _outputByteBuffer;
    private final OutputStream _outputStream;

    public OutputStreamWriter(OutputStream outputStream) {
        this(outputStream, StringPool.DEFAULT_CHARSET_NAME, 8192, false);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName) {
        this(outputStream, charsetName, 8192, false);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName, boolean autoFlush) {
        this(outputStream, charsetName, 8192, autoFlush);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName, int outputBufferSize) {
        this(outputStream, charsetName, outputBufferSize, false);
    }

    public OutputStreamWriter(OutputStream outputStream, String charsetName, int outputBufferSize, boolean autoFlush) {
        if (outputBufferSize < 4) {
            throw new IllegalArgumentException("Output buffer size " + outputBufferSize + " is less than 4");
        }
        if (charsetName == null) {
            charsetName = StringPool.DEFAULT_CHARSET_NAME;
        }
        this._outputStream = outputStream;
        this._charsetName = charsetName;
        this._charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName);
        this._outputByteBuffer = ByteBuffer.allocate(outputBufferSize);
        this._autoFlush = autoFlush;
    }

    @Override
    public void close() throws IOException {
        if (!this._open) {
            return;
        }
        try {
            this._flushEncoder();
            this._flushBuffer();
            this._outputStream.close();
        }
        finally {
            this._open = false;
        }
    }

    @Override
    public void flush() throws IOException {
        this._ensureOpen();
        this._flushBuffer();
        this._outputStream.flush();
    }

    public String getEncoding() {
        return this._charsetName;
    }

    @Override
    public void write(char[] chars) throws IOException {
        this._write(CharBuffer.wrap(chars, 0, chars.length));
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        this._write(CharBuffer.wrap(chars, offset, length));
    }

    @Override
    public void write(int c) throws IOException {
        this._inputCharBuffer.put((char)c);
        this._write(_EMPTY_CHAR_BUFFER);
    }

    @Override
    public void write(String string) throws IOException {
        this._write(CharBuffer.wrap(string, 0, string.length()));
    }

    @Override
    public void write(String string, int offset, int length) throws IOException {
        this._write(CharBuffer.wrap(string, offset, offset + length));
    }

    private void _encodeLeftoverChar(CharBuffer inputCharBuffer, boolean endOfInput) throws IOException {
        if (this._inputCharBuffer.position() == 0) {
            return;
        }
        if (this._inputCharBuffer.position() == 1 && inputCharBuffer.hasRemaining()) {
            this._inputCharBuffer.put(inputCharBuffer.get());
        }
        this._inputCharBuffer.flip();
        this._encodeLoop(this._inputCharBuffer, endOfInput);
        this._inputCharBuffer.compact();
    }

    private void _encodeLoop(CharBuffer inputCharBuffer, boolean endOfInput) throws IOException {
        while (inputCharBuffer.hasRemaining()) {
            CoderResult coderResult = this._charsetEncoder.encode(inputCharBuffer, this._outputByteBuffer, endOfInput);
            if (coderResult.isError()) {
                coderResult.throwException();
            }
            if (coderResult.isUnderflow()) {
                if (this._autoFlush) {
                    this._flushBuffer();
                }
                if (this._inputCharBuffer == inputCharBuffer || !inputCharBuffer.hasRemaining()) break;
                this._inputCharBuffer.put(inputCharBuffer.get());
                break;
            }
            this._flushBuffer();
        }
    }

    private void _ensureOpen() throws IOException {
        if (!this._open) {
            throw new IOException("Stream closed");
        }
    }

    private void _flushBuffer() throws IOException {
        if (this._outputByteBuffer.position() > 0) {
            this._outputStream.write(this._outputByteBuffer.array(), 0, this._outputByteBuffer.position());
            this._outputByteBuffer.rewind();
        }
    }

    private void _flushEncoder() throws IOException {
        this._encodeLeftoverChar(_EMPTY_CHAR_BUFFER, true);
        this._charsetEncoder.encode(_EMPTY_CHAR_BUFFER, this._outputByteBuffer, true);
        while (true) {
            CoderResult coderResult;
            if ((coderResult = this._charsetEncoder.flush(this._outputByteBuffer)).isError()) {
                coderResult.throwException();
            }
            if (coderResult.isUnderflow()) break;
            this._flushBuffer();
        }
    }

    private void _write(CharBuffer inputCharBuffer) throws IOException {
        this._ensureOpen();
        this._encodeLeftoverChar(inputCharBuffer, false);
        this._encodeLoop(inputCharBuffer, false);
    }
}

